package com.provismet.CombatPlusCore.enchantment.loot.condition.doubleEntity;

import com.mojang.serialization.MapCodec;
import com.provismet.CombatPlusCore.enchantment.loot.condition.DoubleEntityCondition;
import com.provismet.CombatPlusCore.enchantment.loot.condition.SingleEntityCondition;
import com.provismet.CombatPlusCore.enchantment.loot.context.CPCLootContext;
import com.provismet.CombatPlusCore.registries.DoubleEntityLootConditionTypes;
import net.minecraft.class_181;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

/**
 * Applies a single condition to the attacker.
 */
public class ApplyToUserCondition extends AbstractSingleWrapperCondition {
    public static final MapCodec<ApplyToUserCondition> CODEC = ApplyToUserCondition.createCodec(ApplyToUserCondition::new);

    protected ApplyToUserCondition (class_5341 condition) {
        super(condition);
    }

    @Override
    public class_5342 method_29325 () {
        return DoubleEntityLootConditionTypes.APPLY_TO_USER;
    }

    @Override
    public boolean test (class_47 lootContext) {
        class_47 userContext = CPCLootContext.createSingleEntity(
            lootContext.method_299(),
            lootContext.method_65013(class_181.field_51805),
            lootContext.method_65013(class_181.field_1226),
            lootContext.method_65013(class_181.field_1229)
        );
        return this.condition.test(userContext);
    }

    public static DoubleEntityCondition.Builder builder (SingleEntityCondition.Builder combatCondition) {
        return () -> new ApplyToUserCondition(combatCondition.build());
    }

    public static DoubleEntityCondition.Builder builder (SingleEntityCondition combatCondition) {
        return () -> new ApplyToUserCondition(combatCondition);
    }

    public static DoubleEntityCondition.Builder builder (class_5341.class_210 condition) {
        return () -> new ApplyToUserCondition(condition.build());
    }

    public static DoubleEntityCondition.Builder builder (class_5341 condition) {
        return () -> new ApplyToUserCondition(condition);
    }
}
