package com.provismet.CombatPlusCore.enchantment.loot.condition.doubleEntity;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.enchantment.loot.condition.DoubleEntityCondition;
import com.provismet.CombatPlusCore.enchantment.loot.context.CPCLootContextParameters;
import com.provismet.CombatPlusCore.registries.DoubleEntityLootConditionTypes;
import com.provismet.CombatPlusCore.utility.CPCRegistries;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_181;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_47;
import net.minecraft.class_5342;

/**
 * Executes a registered predicate against the pair of entities.
 *
 * @param function The identifier of the predicate.
 */
public record DoubleEntityLambdaCondition (class_2960 function) implements DoubleEntityCondition {
    public static final MapCodec<DoubleEntityLambdaCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(class_2960.field_25139.fieldOf("function").forGetter(DoubleEntityLambdaCondition::function)).apply(instance, DoubleEntityLambdaCondition::new));

    @Override
    public class_5342 method_29325 () {
        return DoubleEntityLootConditionTypes.LAMBDA;
    }

    @Override
    public boolean test (class_47 lootContext) {
        Predicate<class_3545<class_1297,class_1297>> predicate = CPCRegistries.DOUBLE_ENTITY_LAMBDA_CONDITION.method_63535(function);
        if (predicate == null) return false;

        class_3545<class_1297,class_1297> pair = new class_3545<>(lootContext.method_65013(class_181.field_1226), lootContext.method_65013(CPCLootContextParameters.TARGET_ENTITY));
        return predicate.test(pair);
    }

    public static DoubleEntityCondition.Builder builder (class_2960 function) {
        return () -> new DoubleEntityLambdaCondition(function);
    }
}
