package com.provismet.CombatPlusCore.enchantment.loot.condition.item;

import com.mojang.serialization.MapCodec;
import com.provismet.CombatPlusCore.enchantment.loot.condition.ItemCondition;
import com.provismet.CombatPlusCore.interfaces.DualWeapon;
import com.provismet.CombatPlusCore.registries.ItemConditionTypes;
import com.provismet.CombatPlusCore.utility.tag.CPCItemTags;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_47;
import net.minecraft.class_5342;

public record IsDualWeaponCondition () implements ItemCondition {
    public static final MapCodec<IsDualWeaponCondition> CODEC = MapCodec.unit(IsDualWeaponCondition::new);

    @Override
    public class_5342 method_29325 () {
        return ItemConditionTypes.IS_DUAL_WEAPON;
    }

    @Override
    public boolean test (class_47 lootContext) {
        class_1799 item = lootContext.method_65013(class_181.field_1229);
        return item.method_31573(CPCItemTags.DUAL_WEAPON) || item.method_7909() instanceof DualWeapon;
    }

    public static ItemCondition.Builder builder () {
        return IsDualWeaponCondition::new;
    }
}
