package com.provismet.CombatPlusCore.enchantment.loot.condition.item;

import com.mojang.serialization.MapCodec;
import com.provismet.CombatPlusCore.enchantment.loot.condition.ItemCondition;
import com.provismet.CombatPlusCore.interfaces.MeleeWeapon;
import com.provismet.CombatPlusCore.registries.ItemConditionTypes;
import com.provismet.CombatPlusCore.utility.tag.CPCItemTags;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_47;
import net.minecraft.class_5342;

public record IsMeleeWeaponCondition () implements ItemCondition {
    public static final MapCodec<IsMeleeWeaponCondition> CODEC = MapCodec.unit(IsMeleeWeaponCondition::new);

    @Override
    public class_5342 method_29325 () {
        return ItemConditionTypes.IS_MELEE_WEAPON;
    }

    @Override
    public boolean test (class_47 lootContext) {
        class_1799 item = lootContext.method_65013(class_181.field_1229);
        return item.method_31573(CPCItemTags.MELEE_WEAPON) || item.method_7909() instanceof MeleeWeapon;
    }

    public static ItemCondition.Builder builder () {
        return IsMeleeWeaponCondition::new;
    }
}
