package com.provismet.CombatPlusCore.enchantment.loot.condition.item;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.CPCMain;
import com.provismet.CombatPlusCore.enchantment.loot.condition.ItemCondition;
import com.provismet.CombatPlusCore.registries.ItemConditionTypes;
import com.provismet.CombatPlusCore.utility.CPCRegistries;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5342;

public record ItemLambdaCondition (class_2960 function) implements ItemCondition {
    public static final MapCodec<ItemLambdaCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(class_2960.field_25139.fieldOf("function").forGetter(ItemLambdaCondition::function)).apply(instance, ItemLambdaCondition::new));

    @Override
    public class_5342 method_29325 () {
        return ItemConditionTypes.LAMBDA;
    }

    @Override
    public boolean test (class_47 lootContext) {
        Predicate<class_1799> predicate = CPCRegistries.ITEM_LAMBDA_CONDITION.method_63535(this.function);
        if (predicate == null) {
            CPCMain.LOGGER.warn("Enchantment attempted to execute unregistered lambda function: {}", this.function.toString());
            return false;
        }
        return predicate.test(lootContext.method_65013(class_181.field_1229));
    }

    public static ItemCondition.Builder builder (class_2960 function) {
        return () -> new ItemLambdaCondition(function);
    }
}
