package com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.enchantment.loot.condition.ItemCondition;
import com.provismet.CombatPlusCore.enchantment.loot.condition.SingleEntityCondition;
import com.provismet.CombatPlusCore.registries.SingleEntityLootConditionTypes;
import java.util.Set;
import net.minecraft.class_169;
import net.minecraft.class_181;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

/**
 * Applies a condition to the item associated with this single entity condition (typically a held item).
 *
 * @param condition The condition to apply.
 */
public record ApplyToItemCondition(class_5341 condition) implements SingleEntityCondition {
    public static final MapCodec<ApplyToItemCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(class_5341.field_51809.fieldOf("applied_condition").forGetter(ApplyToItemCondition::condition)).apply(instance, ApplyToItemCondition::new));

    @Override
    public class_5342 method_29325 () {
        return SingleEntityLootConditionTypes.APPLY_TO_ITEM;
    }

    @Override
    public boolean test (class_47 lootContext) {
        if (lootContext.method_65013(class_181.field_1229) == null) return false;
        return this.condition.test(lootContext);
    }

    @Override
    public Set<class_169<?>> method_293() {
        return SingleEntityCondition.getExtendedRequiredParameters();
    }

    public static SingleEntityCondition.Builder builder (ItemCondition condition) {
        return () -> new ApplyToItemCondition(condition);
    }

    public static SingleEntityCondition.Builder builder (ItemCondition.Builder condition) {
        return () -> new ApplyToItemCondition(condition.build());
    }

    public static SingleEntityCondition.Builder builder (class_5341 condition) {
        return () -> new ApplyToItemCondition((condition));
    }

    public static SingleEntityCondition.Builder builder (class_5341.class_210 condition) {
        return () -> new ApplyToItemCondition((condition.build()));
    }
}
