package com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity;

import com.mojang.serialization.MapCodec;
import com.provismet.CombatPlusCore.enchantment.loot.condition.SingleEntityCondition;
import com.provismet.CombatPlusCore.registries.SingleEntityLootConditionTypes;
import net.minecraft.class_181;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_5342;

public record ExposedToSkyCondition () implements SingleEntityCondition {
    public static final MapCodec<ExposedToSkyCondition> CODEC = MapCodec.unit(ExposedToSkyCondition::new);

    @Override
    public class_5342 method_29325 () {
        return SingleEntityLootConditionTypes.EXPOSED_TO_SKY;
    }

    @Override
    public boolean test (class_47 lootContext) {
        return ExposedToSkyCondition.isSkyVisible(lootContext);
    }

    public static boolean isSkyVisible (class_47 lootContext) {
        class_3218 world = lootContext.method_299();
        class_243 position = lootContext.method_65013(class_181.field_24424);
        return world.method_8311(new class_2338((int)position.field_1352, (int)position.field_1351, (int)position.field_1350));
    }

    public static SingleEntityCondition.Builder builder () {
        return ExposedToSkyCondition::new;
    }
}
