package com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.enchantment.loot.condition.SingleEntityCondition;
import com.provismet.CombatPlusCore.enchantment.loot.context.CPCLootContext;
import com.provismet.CombatPlusCore.registries.SingleEntityLootConditionTypes;
import net.minecraft.class_1309;
import net.minecraft.class_181;
import net.minecraft.class_47;
import net.minecraft.class_5342;
import net.minecraft.class_9704;

/**
 * Compares the entity's health against a provided value.
 *
 * @param comparison The type of comparison to evaluate.
 * @param value The value to compare against.
 */
public record HealthCondition (CPCLootContext.Comparison comparison, class_9704 value) implements SingleEntityCondition {
    public static final MapCodec<HealthCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(CPCLootContext.Comparison.CODEC.fieldOf("comparison").forGetter(HealthCondition::comparison), class_9704.field_51690.fieldOf("value").forGetter(HealthCondition::value)).apply(instance, HealthCondition::new));

    @Override
    public class_5342 method_29325 () {
        return SingleEntityLootConditionTypes.HEALTH;
    }

    @Override
    public boolean test (class_47 lootContext) {
        if (lootContext.method_65013(class_181.field_1226) instanceof class_1309 living) {
            return this.comparison.compare(living.method_6032(), value.method_60188(lootContext.method_65013(class_181.field_51805)));
        }
        return false;
    }

    public static SingleEntityCondition.Builder builder (CPCLootContext.Comparison comparison, class_9704 value) {
        return () -> new HealthCondition(comparison, value);
    }
}
