package com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.CPCMain;
import com.provismet.CombatPlusCore.enchantment.loot.condition.SingleEntityCondition;
import com.provismet.CombatPlusCore.registries.SingleEntityLootConditionTypes;
import com.provismet.CombatPlusCore.utility.CPCRegistries;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_181;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5342;

/**
 * Executes a registered predicate against a single entity.
 *
 * @param function The identifier of the predicate.
 */
public record SingleEntityLambdaCondition (class_2960 function) implements SingleEntityCondition {
    public static final MapCodec<SingleEntityLambdaCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(class_2960.field_25139.fieldOf("function").forGetter(SingleEntityLambdaCondition::function)).apply(instance, SingleEntityLambdaCondition::new));

    @Override
    public class_5342 method_29325 () {
        return SingleEntityLootConditionTypes.LAMBDA;
    }

    @Override
    public boolean test (class_47 lootContext) {
        Predicate<class_1297> predicate = CPCRegistries.SINGLE_ENTITY_LAMBDA_CONDITION.method_63535((this.function));
        if (predicate == null) {
            CPCMain.LOGGER.warn("Enchantment attempted to execute unregistered lambda function: {}", this.function.toString());
            return false;
        }

        class_1297 entity = lootContext.method_65013(class_181.field_1226);
        return predicate.test(entity);
    }

    public static SingleEntityCondition.Builder builder (class_2960 function) {
        return () -> new SingleEntityLambdaCondition(function);
    }
}
