package com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.enchantment.loot.condition.SingleEntityCondition;
import com.provismet.CombatPlusCore.registries.SingleEntityLootConditionTypes;
import net.minecraft.class_1297;
import net.minecraft.class_181;
import net.minecraft.class_47;
import net.minecraft.class_5342;
import net.minecraft.class_9704;

/**
 * Returns true is the entity's age, in ticks, is divisible by the provided value (rounded down).
 *
 * @param interval The value to divide by.
 */
public record TickModuloCondition (class_9704 interval) implements SingleEntityCondition {
    public static final MapCodec<TickModuloCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(class_9704.field_51690.fieldOf("value").forGetter(TickModuloCondition::interval)).apply(instance, TickModuloCondition::new));

    @Override
    public class_5342 method_29325 () {
        return SingleEntityLootConditionTypes.TICK_MODULO;
    }

    @Override
    public boolean test (class_47 lootContext) {
        class_1297 entity = lootContext.method_65013(class_181.field_1226);
        int modulo = (int)this.interval.method_60188(lootContext.method_65013(class_181.field_51805));
        return entity.field_6012 % modulo == 0;
    }

    public static SingleEntityCondition.Builder builder (class_9704 value) {
        return () -> new TickModuloCondition(value);
    }
}
