package com.provismet.CombatPlusCore.enchantment.loot.context;

import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_47;
import net.minecraft.class_8567;

/**
 * Utility class for Combat+ loot contexts.
 *
 * @see com.provismet.CombatPlusCore.enchantment.loot.condition.SingleEntityCondition
 */
public final class CPCLootContext {
    public static class_47 createDoubleEntity (class_3218 world, int level, class_1297 attacker, class_1297 target, class_1799 heldItem) {
        class_8567 paramSet = new class_8567.class_8568(world)
            .method_51874(class_181.field_1226, attacker)
            .method_51874(class_181.field_1230, attacker)
            .method_51874(CPCLootContextParameters.TARGET_ENTITY, target)
            .method_51874(class_181.field_51805, level)
            .method_51874(class_181.field_1229, heldItem)
            .method_51874(class_181.field_24424, attacker.method_73189())
            .method_51875(CPCLootContextTypes.DOUBLE_ENTITY);

        return new class_47.class_48(paramSet).method_309(Optional.empty());
    }

    public static class_47 createReversedDoubleEntity (class_3218 world, int level, class_1297 target, class_1297 attacker, class_1799 heldItem) {
        class_8567 paramSet = new class_8567.class_8568(world)
            .method_51874(class_181.field_1226, target)
            .method_51874(class_181.field_1230, attacker)
            .method_51874(CPCLootContextParameters.TARGET_ENTITY, target)
            .method_51874(class_181.field_51805, level)
            .method_51874(class_181.field_1229, heldItem)
            .method_51874(class_181.field_24424, target.method_73189())
            .method_51875(CPCLootContextTypes.DOUBLE_ENTITY);

        return new class_47.class_48(paramSet).method_309(Optional.empty());
    }

    public static class_47 createSingleEntity (class_3218 world, int level, class_1297 entity, @Nullable class_1799 heldItem) {
        class_1799 weaponStack = heldItem == null ? entity.method_59958() : heldItem;
        class_8567 paramSet = new class_8567.class_8568(world)
            .method_51874(class_181.field_1226, entity)
            .method_51874(class_181.field_51805, level)
            .method_51874(class_181.field_24424, entity.method_73189())
            .method_51874(class_181.field_1229, weaponStack)
            .method_51875(CPCLootContextTypes.SINGLE_ENTITY);

        return new class_47.class_48(paramSet).method_309(Optional.empty());
    }

    public enum Comparison implements class_3542 {
        LESS_THAN("<") {
            @Override
            public boolean compare (float left, float right) {
                return left < right;
            }
        },
        LESS_THAN_OR_EQUAL_TO("<=") {
            @Override
            public boolean compare (float left, float right) {
                return left <= right;
            }
        },
        EQUAL_TO("==") {
            @Override
            public boolean compare (float left, float right) {
                return left == right;
            }
        },
        GREATER_THAN(">") {
            @Override
            public boolean compare (float left, float right) {
                return left > right;
            }
        },
        GREATER_THAN_OR_EQUAL_TO(">=") {
            @Override
            public boolean compare (float left, float right) {
                return left >= right;
            }
        };

        public static final class_3542.class_7292<CPCLootContext.Comparison> CODEC;
        private final String type;

        Comparison (String type) {
            this.type = type;
        }

        public abstract boolean compare (float left, float right);

        @Override
        public String method_15434() {
            return this.type;
        }

        static {
            CODEC = class_3542.method_28140(CPCLootContext.Comparison::values);
        }
    }

    public enum EntityTarget implements class_3542 {
        THIS("this", class_181.field_1226),
        ATTACKER("attacker", class_181.field_1230),
        TARGET("target_entity", CPCLootContextParameters.TARGET_ENTITY);

        public static final class_3542.class_7292<CPCLootContext.EntityTarget> CODEC;
        private final String type;
        private final class_169<? extends class_1297> parameter;

        private EntityTarget (String type, class_169<? extends class_1297> parameter) {
            this.type = type;
            this.parameter = parameter;
        }

        public class_169<? extends class_1297> getParameter() {
            return this.parameter;
        }

        public static CPCLootContext.EntityTarget fromString (String type) {
            CPCLootContext.EntityTarget entityTarget = CODEC.method_42633(type);
            if (entityTarget != null) {
                return entityTarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + type);
        }

        @Override
        public String method_15434() {
            return this.type;
        }

        static {
            CODEC = class_3542.method_28140(CPCLootContext.EntityTarget::values);
        }
    }
}
