package com.provismet.CombatPlusCore.loot.functions;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.registries.CPCLootFunctionTypes;
import com.provismet.lilylib.container.EnchantmentContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class EnchantRandomlyFromKeyLootFunction extends AbstractEnchantmentLootFunction {
    public static final MapCodec<EnchantRandomlyFromKeyLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> EnchantRandomlyFromKeyLootFunction.createCodec(instance).and(class_5321.method_39154(class_7924.field_41265).listOf().fieldOf("enchantments").forGetter(function -> function.keys)).apply(instance, EnchantRandomlyFromKeyLootFunction::new));

    private final List<class_5321<class_1887>> keys;

    protected EnchantRandomlyFromKeyLootFunction (List<class_5341> conditions, boolean onlyCompatibleItems, List<class_5321<class_1887>> keys) {
        super(conditions, onlyCompatibleItems);
        this.keys = keys;
    }

    @Override
    public class_5339<? extends class_120> method_29321 () {
        return CPCLootFunctionTypes.ENCHANT_FROM_KEY;
    }

    @Override
    protected class_1799 method_522 (class_1799 itemStack, class_47 context) {
        if (this.keys.isEmpty()) return itemStack;
        Stream<class_6880.class_6883<class_1887>> valid = this.keys
            .stream()
            .map(key -> context.method_299().method_30349().method_30530(class_7924.field_41265).method_46747(key))
            .filter(entry -> this.isAcceptable(itemStack, entry));

        Optional<class_6880.class_6883<class_1887>> enchantment = class_156.method_40083(valid.toList(), context.method_294());
        if (enchantment.isEmpty()) return itemStack;
        return this.enchantWithRandomLevel(itemStack, enchantment.get(), context.method_294());
    }

    public static com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromKeyLootFunction.Builder create () {
        return new com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromKeyLootFunction.Builder();
    }

    public static class Builder extends AbstractEnchantmentLootFunction.Builder<com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromKeyLootFunction.Builder> {
        private final List<class_5321<class_1887>> keys = new ArrayList<>();

        @Override
        protected com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromKeyLootFunction.Builder method_523 () {
            return this;
        }

        public com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromKeyLootFunction.Builder option (class_5321<class_1887> key) {
            this.keys.add(key);
            return this;
        }

        public com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromKeyLootFunction.Builder option (EnchantmentContainer container) {
            this.keys.add(container.getKey());
            return this;
        }

        @Override
        public class_117 method_515 () {
            return new EnchantRandomlyFromKeyLootFunction(this.method_526(), this.isOnlyForCompatibleItems(), this.keys);
        }
    }
}
