package com.provismet.CombatPlusCore.loot.functions;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.registries.CPCLootFunctionTypes;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

/**
 * Combat+ loot function for enchanting from an enchantment tag.
 * <p>
 * A single, compatible, enchantment will be selected from the tag.
 */
public class EnchantRandomlyFromTagLootFunction extends AbstractEnchantmentLootFunction {
    public static final MapCodec<EnchantRandomlyFromTagLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> EnchantRandomlyFromTagLootFunction.createCodec(instance).and(class_6862.method_40093(class_7924.field_41265).fieldOf("tag").forGetter(function -> function.tagKey)).apply(instance, EnchantRandomlyFromTagLootFunction::new));
    private final class_6862<class_1887> tagKey;

    protected EnchantRandomlyFromTagLootFunction (List<class_5341> conditions, boolean onlyCompatibleItems, class_6862<class_1887> tag) {
        super(conditions, onlyCompatibleItems);
        this.tagKey = tag;
    }

    @Override
    public class_5339<? extends class_120> method_29321 () {
        return CPCLootFunctionTypes.ENCHANT_FROM_TAG;
    }

    @Override
    protected class_1799 method_522 (class_1799 itemStack, class_47 context) {
        if (this.tagKey == null) return itemStack;

        Stream<class_6880<class_1887>> enchantments = context.method_299()
            .method_30349()
            .method_30530(class_7924.field_41265)
            .method_46735(this.tagKey)
            .method_40239()
            .filter(enchant -> this.isAcceptable(itemStack, enchant));
        Optional<class_6880<class_1887>> optionalEnchant = class_156.method_40083(enchantments.toList(), context.method_294());

        if (optionalEnchant.isEmpty()) return itemStack;
        return this.enchantWithRandomLevel(itemStack, optionalEnchant.get(), context.method_294());
    }

    public static com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromTagLootFunction.Builder create () {
        return new com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromTagLootFunction.Builder();
    }

    public static com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromTagLootFunction.Builder create (class_6862<class_1887> tag) {
        return new com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromTagLootFunction.Builder().tag(tag);
    }

    public static class Builder extends AbstractEnchantmentLootFunction.Builder<com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromTagLootFunction.Builder> {
        private class_6862<class_1887> tagKey;

        @Override
        protected com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromTagLootFunction.Builder method_523 () {
            return this;
        }

        public com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromTagLootFunction.Builder tag (class_6862<class_1887> tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        @Override
        public class_117 method_515 () {
            return new EnchantRandomlyFromTagLootFunction(this.method_526(), this.isOnlyForCompatibleItems(), this.tagKey);
        }
    }
}
