package com.provismet.CombatPlusCore.mixin;

import com.provismet.CombatPlusCore.registries.CPCEntityAttributes;
import com.provismet.CombatPlusCore.utility.CPCEnchantmentHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1890.class)
public abstract class EnchantmentHelperMixin {
    @Inject(method="getDamage", at=@At("HEAD"), cancellable=true)
    private static void getCombatPlusDamage (class_3218 world, class_1799 stack, class_1297 target, class_1282 damageSource, float baseDamage, CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue(CPCEnchantmentHelper.getDamage(world, stack, target, damageSource, baseDamage));
    }

    @Inject(method = "getProtectionAmount", at = @At("RETURN"), cancellable = true)
    private static void modifyProtection (class_3218 world, class_1309 user, class_1282 damageSource, CallbackInfoReturnable<Float> cir) {
        Float out = cir.getReturnValue();
        cir.setReturnValue(out * (float)user.method_45325(CPCEntityAttributes.PROTECTION_EFFECTIVENESS));
    }
}
