package com.provismet.CombatPlusCore.mixin;

import com.provismet.CombatPlusCore.items.component.MeleeWeaponComponent;
import com.provismet.CombatPlusCore.registries.CPCDataComponentTypes;
import net.minecraft.class_1792;
import net.minecraft.class_9331;
import net.minecraft.class_9886;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1792.class_1793.class)
public abstract class ItemSettingsMixin {
    @Shadow public abstract <T> class_1792.class_1793 component (class_9331<T> type, T value);

    @Inject(method = "sword", at = @At("HEAD"))
    private void applyDualWeapon (class_9886 material, float attackDamage, float attackSpeed, CallbackInfoReturnable<class_1792.class_1793> cir) {
        this.component(CPCDataComponentTypes.MELEE_WEAPON, MeleeWeaponComponent.createDual(attackDamage + material.comp_2933()));
    }

    @Inject(method = "axe", at = @At("HEAD"))
    private void applyMeleeWeapon (class_9886 material, float attackDamage, float attackSpeed, CallbackInfoReturnable<class_1792.class_1793> cir) {
        this.component(CPCDataComponentTypes.MELEE_WEAPON, MeleeWeaponComponent.createMelee(attackDamage + material.comp_2933()));
    }
}
