package com.provismet.CombatPlusCore.mixin;

import com.provismet.CombatPlusCore.enchantment.effect.CPCDataComponentEntityEffect;
import com.provismet.CombatPlusCore.registries.CPCEnchantmentComponentTypes;
import com.provismet.CombatPlusCore.utility.CPCEnchantmentHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import net.minecraft.class_9698;

@Mixin(class_1799.class)
public abstract class ItemStackMixin {
    @Shadow public abstract class_9304 getEnchantments ();

    @Inject(method = "<init>(Lnet/minecraft/item/ItemConvertible;ILnet/minecraft/component/MergedComponentMap;)V", at = @At("TAIL"))
    private void loadEnchantmentDataComponents (class_1935 item, int count, class_9335 components, CallbackInfo info) {
        class_1799 thisItem = (class_1799)(Object)this;

        CPCEnchantmentHelper.forEachEnchantment((enchantment, level) -> {
            List<class_9698<CPCDataComponentEntityEffect<?>>> componentEffects = enchantment.comp_349().method_60034(CPCEnchantmentComponentTypes.DATA_COMPONENT);
            for (class_9698<CPCDataComponentEntityEffect<?>> effect : componentEffects) {
                effect.comp_2680().apply(thisItem, level);
            }
        }, thisItem);
    }

    @Inject(method = "set", at = @At("HEAD"))
    private <T> void applyItemComponentsFromEnchantments (class_9331<T> type, @Nullable T value, CallbackInfoReturnable<T> cir) {
        if (type != class_9334.field_49633) return;
        if (!(value instanceof class_9304 newComponent)) return;

        class_1799 thisItem = (class_1799)(Object)this;

        // Remove the old components.
        CPCEnchantmentHelper.forEachEnchantment((enchantment, level) -> {
            List<class_9698<CPCDataComponentEntityEffect<?>>> componentEffects = enchantment.comp_349().method_60034(CPCEnchantmentComponentTypes.DATA_COMPONENT);
            for (class_9698<CPCDataComponentEntityEffect<?>> effect : componentEffects) {
                effect.comp_2680().remove(thisItem, level);
            }
        }, thisItem);

        // Add the new components.
        newComponent.method_57539().forEach(entry -> {
            List<class_9698<CPCDataComponentEntityEffect<?>>> componentEffects = entry.getKey().comp_349().method_60034(CPCEnchantmentComponentTypes.DATA_COMPONENT);
            for (class_9698<CPCDataComponentEntityEffect<?>> effect : componentEffects) {
                effect.comp_2680().apply(thisItem, entry.getIntValue());
            }
        });
    }
}
