package com.provismet.CombatPlusCore.mixin;

import com.provismet.CombatPlusCore.registries.CPCEntityAttributes;
import com.provismet.CombatPlusCore.utility.CPCCallbackUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
    public LivingEntityMixin (class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow public abstract class_1268 getActiveHand ();

    @Shadow public abstract @Nullable class_1799 getBlockingItem ();

    @Inject(method = "getDamageBlockedAmount", at = @At(value = "INVOKE", target = "Lnet/minecraft/component/type/BlocksAttacksComponent;onShieldHit(Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/util/Hand;F)V", shift = At.Shift.AFTER))
    private void applyBlockerItemEffects (class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        class_1799 blockingStack = this.getBlockingItem();
        if (blockingStack != null) {
            CPCCallbackUtil.postBlock(world, this.getBlockingItem(), this.getActiveHand().method_73186(), (class_1309)(Object)this, source, amount);
        }
    }

    @Inject(method = "createLivingAttributes", at = @At("RETURN"))
    private static void addCPCAttributes (CallbackInfoReturnable<class_5132.class_5133> cir) {
        cir.getReturnValue()
            .method_26868(CPCEntityAttributes.PROTECTION_EFFECTIVENESS, 1);
    }
}
