package com.provismet.CombatPlusCore.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.provismet.CombatPlusCore.utility.CPCCallbackUtil;
import com.provismet.CombatPlusCore.utility.CPCEnchantmentHelper;
import com.provismet.CombatPlusCore.utility.CPCGameRules;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1796;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3445;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {
    @Shadow public abstract class_1796 getItemCooldownManager ();

    @Shadow public abstract void incrementStat (class_3445<?> stat);

    protected PlayerEntityMixin (class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method="attack", at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getAttackKnockbackAgainst(Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/damage/DamageSource;)F", shift=At.Shift.AFTER))
    private void postApplyHitEffects (class_1297 entity, CallbackInfo info, @Local(ordinal=0) boolean charged, @Local(ordinal=2) boolean critical) {
        if (entity instanceof class_1309 target && this.method_73183() instanceof class_3218 world) {
            if (charged) CPCCallbackUtil.postChargedHit(world, this.method_6047(), class_1304.field_6173, this, target);
            if (critical) CPCCallbackUtil.postCriticalHit(world, this.method_6047(), class_1304.field_6173, this, target);
        }
    }

    @ModifyVariable(method="attack", at=@At(value="STORE"), ordinal=3)
    private boolean stopSweeping (boolean original) {
        if (this.method_73183() instanceof class_3218 world) {
            if (world.method_64395().method_8355(CPCGameRules.SWEEPING_REQUIRES_ENCHANTMENT) && this.method_45325(class_5134.field_51577) <= 0) return false;
        }
        return original;
    }

    @Inject(
        method = "attack",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/enchantment/EnchantmentHelper;onTargetDamaged(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/damage/DamageSource;)V",
            shift = At.Shift.AFTER
        ),
        allow = 1,
        slice = @Slice(
            from = @At(
                value = "INVOKE",
                target = "Lnet/minecraft/world/World;getNonSpectatingEntities(Ljava/lang/Class;Lnet/minecraft/util/math/Box;)Ljava/util/List;"
            ),
            to = @At(
                value = "INVOKE",
                target = "Lnet/minecraft/entity/player/PlayerEntity;spawnSweepAttackParticles()V"
            )
        )
    )
    private void sweepingAppliesChargedHit (class_1297 primaryTarget, CallbackInfo ci, @Local class_1309 sweepTarget, @Local class_3218 world) {
        CPCEnchantmentHelper.postChargedHit(world, this, sweepTarget, class_1304.field_6173);
    }
}
