package com.provismet.CombatPlusCore.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;

import com.provismet.CombatPlusCore.utility.CPCGameRules;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1685;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1835.class)
public abstract class TridentItemMixin extends class_1792 {
    public TridentItemMixin (class_1793 settings) {
        super(settings);
    }
    
    @Inject(method="onStoppedUsing", at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;damage(ILnet/minecraft/entity/player/PlayerEntity;)V"), cancellable=true)
    private void replaceTridentThrow (class_1799 itemStack, class_1937 world, class_1309 user, int remainingUseTicks, CallbackInfoReturnable<Boolean> cir) {
        if (world instanceof class_3218 serverWorld && serverWorld.method_64395().method_8355(CPCGameRules.LOYALTY_STAYS_IN_HAND) && user instanceof class_1657 player) {
            int loyalty = class_1890.method_60169(serverWorld, itemStack, player);

            if (loyalty > 0) {
                class_1799 temp = itemStack.method_7972();
                class_9304.class_9305 tempEnchantmentBuilder = new class_9304.class_9305(class_9304.field_49385);
                class_9304 existingEnchantments = temp.method_58657();

                // Don't want the thrown tridents to return to the player, so loyalty must be removed from the enchantment list.
                for (class_6880<class_1887> enchantmentEntry : existingEnchantments.method_57534()) {
                    if (!enchantmentEntry.comp_349().method_60034(class_9701.field_51678).isEmpty()) continue;
                    tempEnchantmentBuilder.method_57550(enchantmentEntry, existingEnchantments.method_57536(enchantmentEntry));
                }
                temp.method_57379(class_9334.field_49633, tempEnchantmentBuilder.method_57549());

                class_1685 tridentEntity = new class_1685(world, player, temp);
                tridentEntity.method_24919(player, player.method_36455(), player.method_36454(), 0.0f, 2.5f, 1.0f);
                tridentEntity.field_7572 = class_1665.class_1666.field_7592;

                player.method_7357().method_62835(itemStack, 105 - loyalty * 15);
                world.method_8649(tridentEntity);
                class_6880<class_3414> tridentSound = class_1890.method_60165(itemStack, class_9701.field_51654).orElse(class_3417.field_15001);
                world.method_43129(null, tridentEntity, tridentSound.comp_349(), class_3419.field_15248, 1.0f, 1.0f);

                player.method_7259((class_3468.field_15372.method_14956((class_1835)(Object)this)));
                itemStack.method_61653(1, player);

                cir.setReturnValue(true);
            }
        }
    }
}
