package com.provismet.CombatPlusCore.registries;

import com.provismet.CombatPlusCore.CPCMain;
import com.provismet.CombatPlusCore.enchantment.effect.doubleEntity.CodeExecutionDoubleEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.singleEntity.CodeExecutionSingleEntityEffect;
import com.provismet.CombatPlusCore.utility.CPCRegistries;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_3545;

public abstract class LambdaRegistry {
    public static void register () {
        registerSingles();
        registerDoubles();
        registerSingleConditions();
        registerDoubleConditions();
        registerItemConditions();
    }

    private static void registerSingles () {
        register("log", (world, level, context, user, pos) -> CPCMain.LOGGER.info("Single Entity Component: {} triggered this log", user.method_5477().getString()));
    }

    private static void registerDoubles () {
        register("log-charged", (world, level, context, user, target, pos) -> CPCMain.LOGGER.info("Double Entity Component: {} performed a charged attack on {}", user.method_5477().getString(), target.method_5477().getString()));
        register("log-critical", (world, level, context, user, target, pos) -> CPCMain.LOGGER.info("Double Entity Component: {} performed a critical attack on {}", user.method_5477().getString(), target.method_5477().getString()));
        register("log-kill", (world, level, context, user, target, pos) -> CPCMain.LOGGER.info("Double Entity Component: {} killed {}", user.method_5477().getString(), target.method_5477().getString()));
        register("log-block", ((world, level, context, user, target, pos) -> CPCMain.LOGGER.info("Double Entity Component: {} blocked an attack from {}", user.method_5477().getString(), target.method_5477().getString())));
    }

    private static void registerSingleConditions () {
        registerSingleCondition("true", entity -> true);
        registerSingleCondition("false", entity -> false);
    }

    private static void registerDoubleConditions () {
        registerDoubleCondition("true", pair -> true);
        registerDoubleCondition("false", pair -> false);
    }

    private static void registerItemConditions () {
        registerItemCondition("true", item -> true);
        registerItemCondition("false", item -> false);
    }

    private static void register (String name, CodeExecutionSingleEntityEffect.Lambda lambda) {
        class_2378.method_10230(CPCRegistries.SINGLE_ENTITY_LAMBDA, CPCMain.identifier(name), lambda);
    }

    private static void register (String name, CodeExecutionDoubleEntityEffect.Lambda lambda) {
        class_2378.method_10230(CPCRegistries.DOUBLE_ENTITY_LAMBDA, CPCMain.identifier(name), lambda);
    }

    private static void registerSingleCondition (String name, Predicate<class_1297> predicate) {
        class_2378.method_10230(CPCRegistries.SINGLE_ENTITY_LAMBDA_CONDITION, CPCMain.identifier(name), predicate);
    }

    private static void registerDoubleCondition (String name, Predicate<class_3545<class_1297,class_1297>> predicate) {
        class_2378.method_10230(CPCRegistries.DOUBLE_ENTITY_LAMBDA_CONDITION, CPCMain.identifier(name), predicate);
    }

    private static void registerItemCondition (String name, Predicate<class_1799> predicate) {
        class_2378.method_10230(CPCRegistries.ITEM_LAMBDA_CONDITION, CPCMain.identifier(name), predicate);
    }
}
