package com.provismet.datagen.CombatPlusCore;

import com.provismet.CombatPlusCore.CPCMain;
import com.provismet.CombatPlusCore.debug.registries.CPCDebugEnchantments;
import com.provismet.CombatPlusCore.enchantment.effect.component.CooldownGroupComponentEntityEffect;
import com.provismet.CombatPlusCore.registries.CPCEnchantmentComponentTypes;
import com.provismet.CombatPlusCore.utility.tag.CPCItemTags;
import com.provismet.lilylib.datagen.condition.DevModeResourceCondition;
import com.provismet.lilylib.datagen.provider.LilyEnchantmentProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1294;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_190;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_215;
import net.minecraft.class_3483;
import net.minecraft.class_3489;
import net.minecraft.class_47;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9636;
import net.minecraft.class_9701;
import net.minecraft.class_9703;
import net.minecraft.class_9704;
import net.minecraft.class_9711;
import net.minecraft.class_9716;
import net.minecraft.class_9725;
import java.util.concurrent.CompletableFuture;

public class EnchantmentGenerator extends LilyEnchantmentProvider {
    public EnchantmentGenerator (FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    protected void generate (class_7225.class_7874 registries, EnchantmentBuilder builder) {
        CPCDebugEnchantments.getDebugContainer().ifPresent(enchantment -> builder.add(enchantment, new DevModeResourceCondition()));
        CPCDebugEnchantments.getShieldDebugContainer().ifPresent(enchantment -> builder.add(enchantment, new DevModeResourceCondition()));

        builder.add(
            class_1893.field_9118,
            class_1887.method_60030(
                class_1887.method_58443(
                    builder.getItemEntryList(class_3489.field_50108),
                    builder.getItemEntryList(CPCItemTags.DAMAGE_PRIMARY_ENCHANTABLE),
                    10,
                    5,
                    class_1887.method_58441(1, 11),
                    class_1887.method_58441(21, 11),
                    1,
                    class_9274.field_49217
                )
            ).method_60061(
                builder.getEnchantmentEntryList(class_9636.field_51542)
            ).method_60066(
                class_9701.field_51661,
                new class_9711(
                    class_9704.method_60187(1.0f, 0.5f)
                )
            )
        );

        builder.add(
            class_1893.field_9123,
            class_1887.method_60030(
                class_1887.method_58443(
                    builder.getItemEntryList(CPCItemTags.DAMAGE_ENCHANTABLE),
                    builder.getItemEntryList(CPCItemTags.DAMAGE_PRIMARY_ENCHANTABLE),
                    5,
                    5,
                    class_1887.method_58441(5, 8),
                    class_1887.method_58441(25, 8),
                    2,
                    class_9274.field_49217
                )
            ).method_60061(
                builder.getEnchantmentEntryList(class_9636.field_51542)
            ).method_60067(
                CPCEnchantmentComponentTypes.GAMERULE_DAMAGE,
                new class_9711(class_9704.method_60194(2.5f)),
                class_215.method_917(
                    class_47.class_50.field_935,
                    class_2048.class_2049.method_8916().method_8917(class_2050.method_8926(registries.method_46762(class_7924.field_41266), class_3483.field_49931))
                )
            )
        );

        builder.add(
            class_1893.field_9112,
            class_1887.method_60030(
                class_1887.method_58443(
                    builder.getItemEntryList(CPCItemTags.DAMAGE_ENCHANTABLE),
                    builder.getItemEntryList(CPCItemTags.DAMAGE_PRIMARY_ENCHANTABLE),
                    5,
                    5,
                    class_1887.method_58441(5, 8),
                    class_1887.method_58441(25, 8),
                    2,
                    class_9274.field_49217)
            ).method_60061(
                builder.getEnchantmentEntryList(class_9636.field_51542)
            ).method_60067(
                CPCEnchantmentComponentTypes.GAMERULE_DAMAGE,
                new class_9711(class_9704.method_60194(2.5f)),
                class_215.method_917(
                    class_47.class_50.field_935,
                    class_2048.class_2049.method_8916().method_8917(class_2050.method_8926(registries.method_46762(class_7924.field_41266), class_3483.field_48285))
                )
            ).method_60064(
                class_9701.field_51665,
                class_9703.field_51683,
                class_9703.field_51685,
                new class_9716(
                    class_6885.method_40246(class_1294.field_5909),
                    class_9704.method_60186(1.5f),
                    class_9704.method_60187(1.5f, 0.5f),
                    class_9704.method_60186(3.0f),
                    class_9704.method_60186(3.0f)
                ),
                class_215.method_917(
                    class_47.class_50.field_935,
                    class_2048.class_2049.method_8916().method_8917(class_2050.method_8926(registries.method_46762(class_7924.field_41266), class_3483.field_48285))
                ).and(
                    class_190.method_837(class_2022.class_2023.method_8855().method_60488(true))
                )
            )
        );

        builder.add(
            class_1893.field_9124,
            class_1887.method_60030(
                class_1887.method_58443(
                    builder.getItemEntryList(CPCItemTags.ASPECT_ENCHANTABLE),
                    builder.getItemEntryList(CPCItemTags.ASPECT_PRIMARY_ENCHANTABLE),
                    2,
                    2,
                    class_1887.method_58441(10, 20),
                    class_1887.method_58441(60, 20),
                    4,
                    class_9274.field_49217
                )
            ).method_60064(
                class_9701.field_51665,
                class_9703.field_51683,
                class_9703.field_51685,
                new class_9725(class_9704.method_60194(4.0f)),
                class_190.method_837(class_2022.class_2023.method_8855().method_60488(true))
            )
        );

        builder.add(
            class_1893.field_9120,
            class_1887.method_60030(
                class_1887.method_58442(
                    builder.getItemEntryList(class_3489.field_48309),
                    5,
                    3,
                    class_1887.method_58441(12, 7),
                    class_1887.method_58440(50),
                    2,
                    class_9274.field_49217
                )
            ).method_60066(
                class_9701.field_51678, new class_9711(class_9704.method_60194(1.0F))
            ).method_60066(
                CPCEnchantmentComponentTypes.DATA_COMPONENT, new CooldownGroupComponentEntityEffect(CPCMain.identifier("loyalty_trident"))
            )
        );
    }
}
