package com.provismet.datagen.CombatPlusCore;

import com.provismet.CombatPlusCore.debug.registries.CPCDebugEnchantments;
import com.provismet.CombatPlusCore.registries.CPCEntityAttributes;
import com.provismet.CombatPlusCore.utility.CPCDamageTypes;
import com.provismet.CombatPlusCore.utility.CPCGameRules;
import com.provismet.CombatPlusCore.utility.tag.CPCEnchantmentTags;
import com.provismet.CombatPlusCore.utility.tag.CPCItemTags;
import com.provismet.lilylib.datagen.provider.LilyLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;

public class LanguageGenerator extends LilyLanguageProvider {
    protected LanguageGenerator (FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    @Override
    public void generateTranslations (class_7225.class_7874 registryLookup, TranslationBuilder translationBuilder) {
        translationBuilder.add("gamerule.category.combat-plus", "Combat+");
        translationBuilder.add(CPCGameRules.SWEEPING_REQUIRES_ENCHANTMENT.method_27334(), "Sweeping Requires Enchantment");
        translationBuilder.add(CPCGameRules.LOYALTY_STAYS_IN_HAND.method_27334(), "Keep Loyalty Tridents");
        translationBuilder.add(CPCGameRules.PVP_DAMAGE_MODIFIER.method_27334(), "PvP Enchantment Modifier");
        translationBuilder.add(CPCGameRules.PVP_DAMAGE_MODIFIER.method_27334() + ".description", "Modifies the effectiveness of certain damaging enchantments when used against players.");
        translationBuilder.add(CPCGameRules.LETHAL_POISON.method_27334(), "Lethal Poison");

        translationBuilder.add(CPCItemTags.MELEE_WEAPON, "Melee Weapons");
        translationBuilder.add(CPCItemTags.DUAL_WEAPON, "Dual Weapons");

        translationBuilder.add(CPCItemTags.ASPECT_ENCHANTABLE, "Aspect Enchantable");
        translationBuilder.add(CPCItemTags.ASPECT_PRIMARY_ENCHANTABLE, "Primary Aspect Enchantable");
        translationBuilder.add(CPCItemTags.DAMAGE_ENCHANTABLE, "Damage Enchantable");
        translationBuilder.add(CPCItemTags.DAMAGE_PRIMARY_ENCHANTABLE, "Primary Damage Enchantable");
        translationBuilder.add(CPCItemTags.WEAPON_UTILITY_ENCHANTABLE, "Weapon Utility Enchantable");
        translationBuilder.add(CPCItemTags.WEAPON_UTILITY_PRIMARY_ENCHANTABLE, "Primary Weapon Utility Enchantable");
        translationBuilder.add(CPCItemTags.OFFHAND_ENCHANTABLE, "Offhand Enchantable");
        translationBuilder.add(CPCItemTags.OFFHAND_PRIMARY_ENCHANTABLE, "Primary Offhand Enchantable");
        translationBuilder.add(CPCItemTags.SHIELD_ENCHANTABLE, "Shield Enchantable");
        translationBuilder.add(CPCItemTags.SHIELD_PRIMARY_ENCHANTABLE, "Primary Shield Enchantable");

        translationBuilder.add(CPCEnchantmentTags.ADDITIONAL_DAMAGE, "Additional Damage Enchantments");
        translationBuilder.add(CPCEnchantmentTags.ASPECT, "Aspect Enchantments");
        translationBuilder.add(CPCEnchantmentTags.WEAPON_UTILITY, "Weapon Utility Enchantments");
        translationBuilder.add(CPCEnchantmentTags.OFFHAND, "Offhand Enchantments");

        translationBuilder.add("item.combat-plus.debugger", "Example Weapon");
        translationBuilder.add("item.combat-plus.debug_shield", "Example Shield");

        translationBuilder.add(CPCEntityAttributes.PROTECTION_EFFECTIVENESS, "Protection Effectiveness");

        CPCDebugEnchantments.getDebugContainer().ifPresent(enchantment -> this.addEnchantment(translationBuilder, enchantment, "Example Weapon Enchantment", "Logs attacks to the console for debugging purposes."));
        CPCDebugEnchantments.getShieldDebugContainer().ifPresent(enchantment -> this.addEnchantment(translationBuilder, enchantment, "Example Shield Enchantment", "Logs to the console when blocking an attack for debugging purposes."));

        translationBuilder.add("resourcepack.combat-plus.enchanted_numerals", "Enchantment Numerals");
        translationBuilder.add("resourcepack.combat-plus.enchanted_numerals.description", "Numerals go up to level 255");
        translationBuilder.add("resourcepack.combat-plus.enchanted_numbers", "Enchantment Numbers");
        translationBuilder.add("resourcepack.combat-plus.enchanted_numbers.description", "Numerals are now numbers");

        addDeathMessage(translationBuilder, CPCDamageTypes.POISON,
            "%1$s couldn't find an antidote",
            "%1$s succumbed to poison whilst fighting %2$s",
            "%1$s succumbed to poison whilst fighting %2$s using %3$s"
        );
    }
}
