package com.provismet.datagen.CombatPlusCore;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_3545;
import net.minecraft.class_7225;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class NumeralGenerator extends FabricLanguageProvider {
    protected NumeralGenerator (FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    @Override
    public void generateTranslations (class_7225.class_7874 registryLookup, TranslationBuilder translationBuilder) {
        for (int i = 0; i < 256; ++i) {
            translationBuilder.add("enchantment.level." + i, NumeralGenerator.getRomanNumeral(i));
        }
    }

    private static String getRomanNumeral (int value) {
        if (value < 1) return "NULL";

        List<class_3545<Integer, String>> numerals = List.of(
            new class_3545<>(100, "C"), // Enchantments only go up to 255 anyway, so we can stop at C.
            new class_3545<>(90, "XC"),
            new class_3545<>(50, "L"),
            new class_3545<>(40, "XL"),
            new class_3545<>(10, "X"),
            new class_3545<>(9, "IX"),
            new class_3545<>(5, "V"),
            new class_3545<>(4, "IV"),
            new class_3545<>(1, "I")
        );
        StringBuilder numeral = new StringBuilder();

        while (value > 0) {
            for (class_3545<Integer, String> key : numerals) {
                if (value >= key.method_15442()) {
                    value -= key.method_15442();
                    numeral.append(key.method_15441());
                    break;
                }
            }
        }
        return numeral.toString();
    }
}
