/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.hiddenrecipebook_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.hiddenrecipebook_common_neoforge.config.ConfigHandler;
import com.natamus.hiddenrecipebook_common_neoforge.data.Variables;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;

public class BookGUIEvent {
    private static Date lastpress = null;
    private static Screen lastScreen = null;
    private static final HashMap<String, ImageButton> recipe_buttons = new HashMap();
    private static boolean showbook = !ConfigHandler.shouldHideRecipeBook;

    public static void onGUIScreen(Minecraft client, Screen screen, int scaledWidth, int scaledHeight) {
        String guiname = screen.getTitle().getString().toLowerCase();
        if (guiname.equals("crafting") || guiname.equals("furnace")) {
            lastScreen = screen;
            List widgets = screen.children();
            ImageButton imagebutton = null;
            for (GuiEventListener widget : widgets) {
                if (!(widget instanceof ImageButton)) continue;
                imagebutton = (ImageButton)widget;
                try {
                    int height = imagebutton.getHeight();
                    int width = imagebutton.getWidth();
                    if (width != 20 || height != 18) continue;
                    recipe_buttons.put(guiname, imagebutton);
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (showbook) {
                if (imagebutton == null) {
                    if (recipe_buttons.containsKey(guiname)) {
                        ImageButton recipe_button = recipe_buttons.get(guiname);
                        if (!widgets.contains(recipe_button)) {
                            widgets.add(recipe_button);
                        }
                        recipe_button.visible = showbook;
                    }
                    return;
                }
                imagebutton.visible = showbook;
                return;
            }
            if (imagebutton != null) {
                imagebutton.visible = showbook;
            }
        }
    }

    public static void onHotkeyPress() {
        if (!ConfigHandler.allowRecipeBookToggleHotkey) {
            return;
        }
        if (Variables.mc.screen instanceof ChatScreen) {
            return;
        }
        if (Variables.mc.player != null) {
            String guiname;
            String message;
            long ms;
            Date now = new Date();
            if (lastpress != null && (ms = now.getTime() - lastpress.getTime()) < 1000L) {
                return;
            }
            lastpress = now;
            if (showbook) {
                showbook = false;
                message = "Now hiding recipe book button.";
            } else {
                showbook = true;
                message = "Now showing recipe book button.";
            }
            if (lastScreen != null && recipe_buttons.containsKey(guiname = lastScreen.getTitle().getString().toLowerCase())) {
                ImageButton button = recipe_buttons.get(guiname);
                button.visible = showbook;
            }
            if (ConfigHandler.showMessageOnRecipeBookToggle) {
                MessageFunctions.sendMessage((Player)Variables.mc.player, (String)message, (ChatFormatting)ChatFormatting.DARK_GREEN);
            }
        }
    }
}

