/*
 * Decompiled with CFR 0.152.
 */
package malfu.bc_particle.config;

import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import malfu.bc_particle.config.ColorLightSettings;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class WeaponSettingsLoader
implements SimpleResourceReloadListener<Map<String, ColorLightSettings>> {
    public static final WeaponSettingsLoader INSTANCE = new WeaponSettingsLoader();
    private Map<String, ColorLightSettings> settingsMap = new HashMap<String, ColorLightSettings>();

    public CompletableFuture<Map<String, ColorLightSettings>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> this.prepare(manager, profiler), executor);
    }

    public CompletableFuture<Void> apply(Map<String, ColorLightSettings> data, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> this.applySettings(data), executor);
    }

    private Map<String, ColorLightSettings> prepare(class_3300 resourceManager, class_3695 profiler) {
        HashMap<String, ColorLightSettings> combinedMap = new HashMap<String, ColorLightSettings>();
        Map resourceMap = resourceManager.method_14488("bc_particle", path -> path.method_12832().endsWith(".json"));
        for (class_2960 resourceId : resourceMap.keySet()) {
            String path2 = resourceId.method_12832();
            if (!path2.endsWith("weapon_settings.json")) continue;
            try {
                class_3298 resource = (class_3298)resourceMap.get(resourceId);
                try {
                    InputStream stream = resource.method_14482();
                    try (InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject rootObject = class_3518.method_15255((Reader)reader);
                        JsonObject valuesObject = class_3518.method_15296((JsonObject)rootObject, (String)"values");
                        for (String weaponId : valuesObject.keySet()) {
                            JsonObject settingsObject = class_3518.method_15296((JsonObject)valuesObject, (String)weaponId);
                            ColorLightSettings settings = this.parseSettings(settingsObject);
                            combinedMap.put(weaponId, settings);
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse weapon settings from: " + String.valueOf(resourceId));
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to load weapon settings from: " + String.valueOf(resourceId));
                e.printStackTrace();
            }
        }
        return combinedMap;
    }

    private ColorLightSettings parseSettings(JsonObject json) {
        return new ColorLightSettings(class_3518.method_15253((JsonObject)json, (String)"color_hex", (String)"FFFFFF"), class_3518.method_15253((JsonObject)json, (String)"color_hex_sec", (String)"D9D9D9"), class_3518.method_15258((JsonObject)json, (String)"light", (boolean)false));
    }

    private void applySettings(Map<String, ColorLightSettings> newSettingsMap) {
        this.settingsMap = newSettingsMap;
        System.out.println("[BC Particles] Loaded weapon settings for " + newSettingsMap.size() + " weapons.");
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"bc_particle", (String)"weapon_settings_loader");
    }

    public ColorLightSettings getSettings(String weaponId) {
        return this.settingsMap.getOrDefault(weaponId, null);
    }
}

