/*
 * Decompiled with CFR 0.152.
 */
package malfu.bc_particle.config;

import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import malfu.bc_particle.config.ColorLightSettings;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

public class EnchantmentSettingsLoader
implements SimpleSynchronousResourceReloadListener {
    public static final EnchantmentSettingsLoader INSTANCE = new EnchantmentSettingsLoader();
    private Map<String, ColorLightSettings> settingsMap = new HashMap<String, ColorLightSettings>();

    public void method_14491(class_3300 resourceManager) {
        HashMap<String, ColorLightSettings> combinedMap = new HashMap<String, ColorLightSettings>();
        Map resourceMap = resourceManager.method_14488("bc_particle", path -> path.method_12832().endsWith(".json"));
        for (class_2960 resourceId : resourceMap.keySet()) {
            String path2 = resourceId.method_12832();
            if (!path2.endsWith("enchantment_settings.json")) continue;
            try {
                class_3298 resource = (class_3298)resourceMap.get(resourceId);
                try {
                    InputStream stream = resource.method_14482();
                    try (InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject rootObject = class_3518.method_15255((Reader)reader);
                        JsonObject valuesObject = class_3518.method_15296((JsonObject)rootObject, (String)"values");
                        for (String enchantmentId : valuesObject.keySet()) {
                            JsonObject settingsObject = class_3518.method_15296((JsonObject)valuesObject, (String)enchantmentId);
                            ColorLightSettings settings = this.parseSettings(settingsObject);
                            combinedMap.put(enchantmentId, settings);
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse enchantment settings from: " + String.valueOf(resourceId));
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to load enchantment settings from: " + String.valueOf(resourceId));
                e.printStackTrace();
            }
        }
        this.settingsMap = combinedMap;
        System.out.println("[BC Particles] Loaded enchantment settings for " + combinedMap.size() + " enchantments from client");
    }

    private ColorLightSettings parseSettings(JsonObject json) {
        return new ColorLightSettings(class_3518.method_15253((JsonObject)json, (String)"color_hex", (String)"FFFFFF"), class_3518.method_15253((JsonObject)json, (String)"color_hex_sec", (String)"D9D9D9"), class_3518.method_15258((JsonObject)json, (String)"light", (boolean)true));
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"bc_particle", (String)"enchantment_settings_loader");
    }

    public ColorLightSettings getSettings(String enchantmentId) {
        return this.settingsMap.getOrDefault(enchantmentId, null);
    }

    public static void loadNow() {
        class_310 client = class_310.method_1551();
        if (client != null && client.method_1478() != null) {
            INSTANCE.method_14491(client.method_1478());
        }
    }
}

