/*
 * Decompiled with CFR 0.152.
 */
package malfu.bc_particle.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import malfu.bc_particle.config.ParticleSettings;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class ParticleSettingsLoader
implements SimpleResourceReloadListener<Map<String, List<ParticleSettings>>> {
    public static final ParticleSettingsLoader INSTANCE = new ParticleSettingsLoader();
    private Map<String, List<ParticleSettings>> settingsMap = new HashMap<String, List<ParticleSettings>>();

    public CompletableFuture<Map<String, List<ParticleSettings>>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> this.prepare(manager, profiler), executor);
    }

    public CompletableFuture<Void> apply(Map<String, List<ParticleSettings>> data, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> this.applySettings(data), executor);
    }

    private Map<String, List<ParticleSettings>> prepare(class_3300 resourceManager, class_3695 profiler) {
        HashMap<String, List<ParticleSettings>> combinedMap = new HashMap<String, List<ParticleSettings>>();
        Map resourceMap = resourceManager.method_14488("bc_particle", path -> path.method_12832().endsWith(".json"));
        for (class_2960 resourceId : resourceMap.keySet()) {
            String path2 = resourceId.method_12832();
            if (!path2.endsWith("particle_settings.json")) continue;
            try {
                class_3298 resource = (class_3298)resourceMap.get(resourceId);
                try {
                    InputStream stream = resource.method_14482();
                    try (InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject rootObject = class_3518.method_15255((Reader)reader);
                        JsonObject valuesObject = class_3518.method_15296((JsonObject)rootObject, (String)"values");
                        for (String animationName : valuesObject.keySet()) {
                            JsonElement element = valuesObject.get(animationName);
                            ArrayList<ParticleSettings> settingsList = new ArrayList<ParticleSettings>();
                            if (element.isJsonArray()) {
                                JsonArray settingsArray = element.getAsJsonArray();
                                for (JsonElement settingElement : settingsArray) {
                                    JsonObject settingsObject = settingElement.getAsJsonObject();
                                    ParticleSettings settings = this.parseSettings(settingsObject);
                                    settingsList.add(settings);
                                }
                            } else if (element.isJsonObject()) {
                                JsonObject settingsObject = element.getAsJsonObject();
                                ParticleSettings settings = this.parseSettings(settingsObject);
                                settingsList.add(settings);
                            }
                            combinedMap.put(animationName, settingsList);
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse particle settings from: " + resourceId);
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to load particle settings from: " + resourceId);
                e.printStackTrace();
            }
        }
        return combinedMap;
    }

    private ParticleSettings parseSettings(JsonObject json) {
        return new ParticleSettings(class_3518.method_15253((JsonObject)json, (String)"particle_type", (String)"none"), class_3518.method_15277((JsonObject)json, (String)"z_addition", (float)0.0f), class_3518.method_15277((JsonObject)json, (String)"x_addition", (float)0.0f), class_3518.method_15277((JsonObject)json, (String)"y_addition", (float)0.0f), class_3518.method_15277((JsonObject)json, (String)"local_yaw", (float)0.0f), class_3518.method_15277((JsonObject)json, (String)"pitch_addition", (float)0.0f), class_3518.method_15277((JsonObject)json, (String)"roll_set", (float)0.0f));
    }

    private void applySettings(Map<String, List<ParticleSettings>> newSettingsMap) {
        this.settingsMap = newSettingsMap;
        System.out.println("[BC Particles] Loaded settings for " + newSettingsMap.size() + " animations.");
    }

    public class_2960 getFabricId() {
        return new class_2960("bc_particle", "settings_loader");
    }

    public List<ParticleSettings> getSettings(String animationName) {
        return this.settingsMap.getOrDefault(animationName, List.of(ParticleSettings.DEFAULT));
    }
}

