/*
 * Decompiled with CFR 0.152.
 */
package justblahaj.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BrownBlahajBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public BrownBlahajBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOL).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).ignitedByLava());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.just_blahaj.brown_blahaj.description_0"));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)BrownBlahajBlock.box((double)4.0, (double)0.0, (double)10.0, (double)6.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{BrownBlahajBlock.box((double)10.0, (double)0.0, (double)10.0, (double)12.0, (double)1.0, (double)12.0), BrownBlahajBlock.box((double)6.0, (double)1.0, (double)15.0, (double)10.0, (double)3.0, (double)16.0), BrownBlahajBlock.box((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)3.0, (double)15.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)BrownBlahajBlock.box((double)10.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)6.0), (VoxelShape[])new VoxelShape[]{BrownBlahajBlock.box((double)4.0, (double)0.0, (double)4.0, (double)6.0, (double)1.0, (double)6.0), BrownBlahajBlock.box((double)6.0, (double)1.0, (double)0.0, (double)10.0, (double)3.0, (double)1.0), BrownBlahajBlock.box((double)6.0, (double)0.0, (double)1.0, (double)10.0, (double)3.0, (double)11.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)BrownBlahajBlock.box((double)10.0, (double)0.0, (double)10.0, (double)12.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{BrownBlahajBlock.box((double)10.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)6.0), BrownBlahajBlock.box((double)15.0, (double)1.0, (double)6.0, (double)16.0, (double)3.0, (double)10.0), BrownBlahajBlock.box((double)5.0, (double)0.0, (double)6.0, (double)15.0, (double)3.0, (double)10.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)BrownBlahajBlock.box((double)4.0, (double)0.0, (double)4.0, (double)6.0, (double)1.0, (double)6.0), (VoxelShape[])new VoxelShape[]{BrownBlahajBlock.box((double)4.0, (double)0.0, (double)10.0, (double)6.0, (double)1.0, (double)12.0), BrownBlahajBlock.box((double)0.0, (double)1.0, (double)6.0, (double)1.0, (double)3.0, (double)10.0), BrownBlahajBlock.box((double)1.0, (double)0.0, (double)6.0, (double)11.0, (double)3.0, (double)10.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

