/*
 * Decompiled with CFR 0.152.
 */
package com.progamer91.smartchestfinder;

public class ChestData {
    private final String tag;
    private final String world;
    private final int x;
    private final int y;
    private final int z;

    public ChestData(String tag, String world, int x, int y, int z) {
        this.tag = tag;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String getTag() {
        return this.tag;
    }

    public String getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public double distanceSquaredTo(int playerX, int playerY, int playerZ) {
        double dx = this.x - playerX;
        double dy = this.y - playerY;
        double dz = this.z - playerZ;
        return dx * dx + dy * dy + dz * dz;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChestData chestData = (ChestData)obj;
        return this.x == chestData.x && this.y == chestData.y && this.z == chestData.z && this.world.equals(chestData.world);
    }

    public int hashCode() {
        return this.world.hashCode() + this.x + this.y + this.z;
    }
}

