/*
 * Decompiled with CFR 0.152.
 */
package com.progamer91.smartchestfinder;

import com.progamer91.smartchestfinder.ChestData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestDataManager {
    private final JavaPlugin plugin;
    private final File dataFile;
    private FileConfiguration dataConfig;
    private final Map<String, List<ChestData>> playerChests;

    public ChestDataManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "chests.yml");
        this.playerChests = new HashMap<String, List<ChestData>>();
    }

    public void loadData() {
        if (!this.dataFile.exists()) {
            this.plugin.getDataFolder().mkdirs();
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create chests.yml file!");
                return;
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        if (this.dataConfig.contains("players")) {
            for (String playerName : this.dataConfig.getConfigurationSection("players").getKeys(false)) {
                ArrayList<ChestData> chests = new ArrayList<ChestData>();
                List chestList = this.dataConfig.getMapList("players." + playerName);
                for (Map chestMap : chestList) {
                    String tag = (String)chestMap.get("tag");
                    String world = (String)chestMap.get("world");
                    int x = (Integer)chestMap.get("x");
                    int y = (Integer)chestMap.get("y");
                    int z = (Integer)chestMap.get("z");
                    chests.add(new ChestData(tag, world, x, y, z));
                }
                this.playerChests.put(playerName, chests);
            }
        }
    }

    public void saveData() {
        this.dataConfig = new YamlConfiguration();
        for (Map.Entry<String, List<ChestData>> entry : this.playerChests.entrySet()) {
            String playerName = entry.getKey();
            List<ChestData> chests = entry.getValue();
            ArrayList chestList = new ArrayList();
            for (ChestData chest : chests) {
                HashMap<String, Object> chestMap = new HashMap<String, Object>();
                chestMap.put("tag", chest.getTag());
                chestMap.put("world", chest.getWorld());
                chestMap.put("x", chest.getX());
                chestMap.put("y", chest.getY());
                chestMap.put("z", chest.getZ());
                chestList.add(chestMap);
            }
            this.dataConfig.set("players." + playerName, chestList);
        }
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save chests.yml file!");
        }
    }

    public void addChest(String playerName, ChestData chestData) {
        List chests = this.playerChests.computeIfAbsent(playerName, k -> new ArrayList());
        chests.removeIf(existing -> existing.equals(chestData));
        chests.add(chestData);
        this.saveData();
    }

    public void removeChest(String playerName, String world, int x, int y, int z) {
        List<ChestData> chests = this.playerChests.get(playerName);
        if (chests != null) {
            chests.removeIf(chest -> chest.getWorld().equals(world) && chest.getX() == x && chest.getY() == y && chest.getZ() == z);
            this.saveData();
        }
    }

    public ChestData findNearestChest(String playerName, String tag, String currentWorld, int playerX, int playerY, int playerZ) {
        List<ChestData> chests = this.playerChests.get(playerName);
        if (chests == null) {
            return null;
        }
        ChestData nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (ChestData chest : chests) {
            double distance;
            if (!chest.getTag().equalsIgnoreCase(tag) || !chest.getWorld().equals(currentWorld) || !((distance = chest.distanceSquaredTo(playerX, playerY, playerZ)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearest = chest;
        }
        return nearest;
    }
}

