/*
 * Decompiled with CFR 0.152.
 */
package com.progamer91.smartchestfinder;

import com.progamer91.smartchestfinder.ChestData;
import com.progamer91.smartchestfinder.ChestDataManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FindChestCommand
implements CommandExecutor {
    private final ChestDataManager dataManager;

    public FindChestCommand(ChestDataManager dataManager) {
        this.dataManager = dataManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only players can use this command!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(Component.text((String)"Usage: /findchest <tag>").color((TextColor)NamedTextColor.RED));
            return true;
        }
        String tag = args[0];
        Location playerLoc = player.getLocation();
        ChestData nearestChest = this.dataManager.findNearestChest(player.getName(), tag, playerLoc.getWorld().getName(), playerLoc.getBlockX(), playerLoc.getBlockY(), playerLoc.getBlockZ());
        if (nearestChest == null) {
            player.sendMessage(Component.text((String)"No chest found with that tag!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Location chestLocation = new Location(player.getWorld(), (double)nearestChest.getX(), (double)nearestChest.getY(), (double)nearestChest.getZ());
        player.setCompassTarget(chestLocation);
        player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Nearest chest with tag '").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)tag).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)"': [").color((TextColor)NamedTextColor.GREEN))).append(Component.text((int)nearestChest.getX()).color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)", ").color((TextColor)NamedTextColor.GREEN))).append(Component.text((int)nearestChest.getY()).color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)", ").color((TextColor)NamedTextColor.GREEN))).append(Component.text((int)nearestChest.getZ()).color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)"] in world ").color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)nearestChest.getWorld()).color((TextColor)NamedTextColor.AQUA)));
        return true;
    }
}

