/*
 * Decompiled with CFR 0.152.
 */
package com.progamer91.smartchestfinder;

import com.progamer91.smartchestfinder.ChestDataManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;

public class UntagChestCommand
implements CommandExecutor {
    private final ChestDataManager dataManager;

    public UntagChestCommand(ChestDataManager dataManager) {
        this.dataManager = dataManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only players can use this command!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        RayTraceResult rayTrace = player.rayTraceBlocks(5.0);
        if (rayTrace == null || rayTrace.getHitBlock() == null) {
            player.sendMessage(Component.text((String)"You must look at a chest!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Block block = rayTrace.getHitBlock();
        if (block.getType() != Material.CHEST && block.getType() != Material.TRAPPED_CHEST) {
            player.sendMessage(Component.text((String)"You must look at a chest!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Location loc = block.getLocation();
        this.dataManager.removeChest(player.getName(), loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        player.sendMessage(Component.text((String)"Chest tag removed!").color((TextColor)NamedTextColor.GREEN));
        return true;
    }
}

