package com.zhengzhengyiyimc;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1269;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_7172;
import org.lwjgl.glfw.GLFW;

import com.zhengzhengyiyimc.config.ModConfig;
import com.zhengzhengyiyimc.hub.HubRenderer;

public class LazyboostClient implements ClientModInitializer {
    private long windowHandle = -1L;
    private boolean isFpsReduced = false;
    private int originalFpsLimit = 120;

	private class_304 openConfigKey;

    @Override
    public void onInitializeClient() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);

        AutoConfig.getConfigHolder(ModConfig.class).registerSaveListener((manager, config) -> {
            class_310.method_1551().field_1773.method_35768(config.renderHands);

            return class_1269.field_5812;
        });

		openConfigKey = KeyBindingHelper.registerKeyBinding(new class_304(
                "key.lazyboost.opengui",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_UNKNOWN,
                "key.lazyboost.key"
        ));

		HubRenderer.init();

        ClientTickEvents.START_CLIENT_TICK.register(mc -> {
            if (windowHandle == -1L && mc.method_22683() != null) {
                windowHandle = mc.method_22683().method_4490();
            }

            class_315 options = class_310.method_1551().field_1690;

            options.method_42473().method_41748(AutoConfig.getConfigHolder(ModConfig.class).get().gamma);
        });

        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
    }

    private void onClientTick(class_310 client) {
		if (openConfigKey.method_1434()) {
			client.method_1507(AutoConfig.getConfigScreen(ModConfig.class, client.field_1755).get());
		}

		if (!AutoConfig.getConfigHolder(ModConfig.class).getConfig().enableAutoFpsReduction) return;

        if (client.field_1724 == null || client.field_1687 == null || windowHandle == -1L) {
            return;
        }

        boolean isFocused = GLFW.glfwGetWindowAttrib(windowHandle, GLFW.GLFW_FOCUSED) == 1;
        boolean isIconified = GLFW.glfwGetWindowAttrib(windowHandle, GLFW.GLFW_ICONIFIED) == 1;

        class_7172<Integer> fpsOption = client.field_1690.method_42524();

        if (isFocused && !isIconified) {
            if (isFpsReduced) {
                fpsOption.method_41748(originalFpsLimit);
                isFpsReduced = false;
            }
        } else {
            if (!isFpsReduced) {
                originalFpsLimit = fpsOption.method_41753();
            }
            if (fpsOption.method_41753() != 12) {
                fpsOption.method_41748(12);
            }
            isFpsReduced = true;
        }
    }
}
