package com.zhengzhengyiyimc.hub;

import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import java.text.DecimalFormat;
import java.util.Optional;

import com.zhengzhengyiyimc.Lazyboost;
import com.zhengzhengyiyimc.config.ModConfig;

public class HubRenderer {
    private static HubRenderer INSTANCE;
    private final DecimalFormat df = new DecimalFormat("#.##");
    private int currentFPS = 0;
    private float currentTPS = 20.0f;
    private int frameCount = 0;
    private long lastFpsUpdate = 0;
    private long lastTpsUpdate = 0;
    private long lastBiomeUpdate = 0;
    private String cachedBiomeText = "Biome: Unknown";
    private static final long FPS_UPDATE_INTERVAL = 500_000_000L;
    private static final long TPS_UPDATE_INTERVAL = 1_000_000_000L;
    private static final long BIOME_UPDATE_INTERVAL_MS = 2000;

    private HubRenderer() {}

    public static void init() {
        if (INSTANCE == null) {
            INSTANCE = new HubRenderer();
            HudRenderCallback.EVENT.register(INSTANCE::onHudRender);
        }
    }

    private void onHudRender(class_332 drawContext, float tickDelta) {
        renderCustomHud(drawContext, tickDelta);
    }

    private void renderCustomHud(class_332 drawContext, float tickDelta) {
        class_310 client = class_310.method_1551();
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if (!config.smallhub || client.field_1724 == null || client.field_1687 == null) {
            return;
        }

        updateFPS();
        updateTPS(client);
        updateBiomeText(client);

        class_327 textRenderer = client.field_1772;
        class_2338 playerPos = client.field_1724.method_24515();
        String positionText = String.format("X: %d Y: %d Z: %d", playerPos.method_10263(), playerPos.method_10264(), playerPos.method_10260());
        String fpsText = "FPS: " + currentFPS;
        String tpsText = "TPS: " + df.format(currentTPS);
        int lineHeight = textRenderer.field_2000 + 1;
        int startX = 4;
        int startY = 4;

        drawContext.method_51433(textRenderer, positionText, startX, startY, 0xFFFFFF, true);
        drawContext.method_51433(textRenderer, fpsText, startX, startY + lineHeight, 0xFFFF00, true);
        drawContext.method_51433(textRenderer, tpsText, startX, startY + 2 * lineHeight, 0x00FF00, true);
        drawContext.method_51433(textRenderer, cachedBiomeText, startX, startY + 3 * lineHeight, 0x00FFFF, true);
    }

    private void updateFPS() {
        long currentTime = System.nanoTime();
        frameCount++;
        if (currentTime - lastFpsUpdate >= FPS_UPDATE_INTERVAL) {
            long timeElapsed = currentTime - lastFpsUpdate;
            currentFPS = (int) ((long) frameCount * 1_000_000_000L / timeElapsed);
            frameCount = 0;
            lastFpsUpdate = currentTime;
        }
    }

    private void updateTPS(class_310 client) {
    	try {
	        long currentTime = System.nanoTime();
	        if (currentTime - lastTpsUpdate >= TPS_UPDATE_INTERVAL) {
	            if (client.method_1496() && client.method_1576() != null) {
	                // currentTPS = client.getServer().getTickManager().getTickRate();
	            	currentTPS = client.method_1576().method_54832();
	//                currentTPS = 20.0f;
	            } else {
	                currentTPS = 20.0f;
	            }
	            lastTpsUpdate = currentTime;
	        }
    	} catch (Exception e) {
    		Lazyboost.LOGGER.warn(e.toString());
    	}
    }

    private void updateBiomeText(class_310 client) {
        long currentMillis = System.currentTimeMillis();
        if (currentMillis - lastBiomeUpdate >= BIOME_UPDATE_INTERVAL_MS) {
            cachedBiomeText = "Biome: Unknown";
            class_2338 playerPos = client.field_1724.method_24515();
            if (client.field_1687.method_30349() != null) {
                Optional<class_5321<class_1959>> biomeKey = client.field_1687.method_30349().method_30530(class_7924.field_41236)
                        .method_29113(client.field_1687.method_23753(playerPos).comp_349());
                if (biomeKey.isPresent()) {
                    class_2960 id = biomeKey.get().method_29177();
                    cachedBiomeText = "Biome: " + id.method_12832();
                }
            }
            lastBiomeUpdate = currentMillis;
        }
    }
}