package com.zhengzhengyiyimc.mixin.client;

import java.util.ArrayList;
import java.util.List;

import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.zhengzhengyiyimc.config.ModConfig;

import me.shedaniel.autoconfig.AutoConfig;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.client.render.*;

@Mixin(class_761.class)
public class WorldRendererMixin {
    private static final List<class_238> BOXES_TO_RENDER = new ArrayList<>();

    @Inject(method = "renderWeather", at = @At("HEAD"), cancellable = true)
    private void disablerenderWeather(class_765 manager, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        if (AutoConfig.getConfigHolder(ModConfig.class).getConfig().disableWeather) ci.cancel();
    }

    @Inject(method = "render", at = @At("HEAD"))
    private void onRenderStart(CallbackInfo ci) {
        BOXES_TO_RENDER.clear();
    }

    @Inject(method = "renderEntity", at = @At("HEAD"), cancellable = true)
    private void renderEntity(class_1297 entity, double cameraX, double cameraY, double cameraZ, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        double distance = entity.method_19538().method_1022(client.field_1724.method_19538());
        if (distance >= config.entity_render_distance) {
            ci.cancel();

            if (client.field_1724 == null || client.field_1687 == null) return;

            class_4184 camera = client.field_1773.method_19418();
            class_243 camPos = camera.method_19326();

            class_238 box = entity.method_5829();
            double minX = box.field_1323 - camPos.field_1352;
            double minY = box.field_1322 - camPos.field_1351;
            double minZ = box.field_1321 - camPos.field_1350;
            double maxX = box.field_1320 - camPos.field_1352;
            double maxY = box.field_1325 - camPos.field_1351;
            double maxZ = box.field_1324 - camPos.field_1350;

            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask(false);
            RenderSystem.setShader(class_757::method_34540);
            buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);

            drawAABB(buffer, new class_238(minX, minY, minZ, maxX, maxY, maxZ), 1.0f, 0.0f, 0.0f, 0.3f);

            tessellator.method_1350();
            RenderSystem.depthMask(true);
            RenderSystem.disableBlend();
        }
    }
    
    private void drawAABB(class_287 buffer, class_238 box, float r, float g, float b, float a) {
        buffer.method_22912(box.field_1323, box.field_1322, box.field_1321).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1320, box.field_1322, box.field_1321).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1320, box.field_1322, box.field_1321).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1320, box.field_1322, box.field_1324).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1320, box.field_1322, box.field_1324).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1323, box.field_1322, box.field_1324).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1323, box.field_1322, box.field_1324).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1323, box.field_1322, box.field_1321).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1323, box.field_1325, box.field_1321).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1320, box.field_1325, box.field_1321).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1320, box.field_1325, box.field_1321).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1320, box.field_1325, box.field_1324).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1320, box.field_1325, box.field_1324).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1323, box.field_1325, box.field_1324).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1323, box.field_1325, box.field_1324).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1323, box.field_1325, box.field_1321).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1323, box.field_1322, box.field_1321).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1323, box.field_1325, box.field_1321).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1320, box.field_1322, box.field_1321).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1320, box.field_1325, box.field_1321).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1320, box.field_1322, box.field_1324).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1320, box.field_1325, box.field_1324).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1323, box.field_1322, box.field_1324).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1323, box.field_1325, box.field_1324).method_22915(r, g, b, a).method_1344();
    }

    @Inject(method = "renderLayer", at = @At("HEAD"), cancellable = true)
    private void renderLayer(class_1921 renderLayer, double cameraX, double cameraY, double cameraZ, Matrix4f positionMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (renderLayer == class_1921.method_23583() && AutoConfig.getConfigHolder(ModConfig.class).getConfig().disablewater) {
            ci.cancel();
            
//            TODO - make sure water renders.
        }
    }
}
