/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.hub;

import io.github.zhengzhengyiyi.config.ModConfig;
import java.text.DecimalFormat;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class HubRenderer {
    private static HubRenderer INSTANCE;
    private final DecimalFormat df = new DecimalFormat("#.##");
    private int currentFPS = 0;
    private float currentTPS = 20.0f;
    private int frameCount = 0;
    private long lastFpsUpdate = 0L;
    private long lastTpsUpdate = 0L;
    private static final long FPS_UPDATE_INTERVAL = 500000000L;
    private static final long TPS_UPDATE_INTERVAL = 1000000000L;

    private HubRenderer() {
    }

    @Deprecated
    public static void init() {
        if (INSTANCE == null) {
            INSTANCE = new HubRenderer();
            HudRenderCallback.EVENT.register((context, tickCounter) -> INSTANCE.onHudRender(context));
        }
    }

    private void onHudRender(class_332 drawContext) {
        this.renderCustomHud(drawContext);
    }

    private void renderCustomHud(class_332 drawContext) {
        class_310 client = class_310.method_1551();
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        if (!config.smallhub || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        this.updateFPS();
        this.updateTPS(client);
        class_327 textRenderer = client.field_1772;
        class_2338 playerPos = client.field_1724.method_24515();
        String positionText = String.format("X: %d Y: %d Z: %d", playerPos.method_10263(), playerPos.method_10264(), playerPos.method_10260());
        String fpsText = "FPS: " + this.currentFPS;
        String tpsText = "TPS: " + this.df.format(this.currentTPS);
        Objects.requireNonNull(textRenderer);
        int lineHeight = 9 + 2;
        int startX = 4;
        int startY = 4;
        System.out.println(fpsText);
        drawContext.method_51433(textRenderer, positionText, startX, startY, 0xFFFFFF, true);
        drawContext.method_51433(textRenderer, fpsText, startX, startY + lineHeight, 0xFFFF00, true);
        drawContext.method_51433(textRenderer, tpsText, startX, startY + 2 * lineHeight, 65280, true);
    }

    private void updateFPS() {
        long currentTime = System.nanoTime();
        ++this.frameCount;
        if (currentTime - this.lastFpsUpdate >= 500000000L) {
            long timeElapsed = currentTime - this.lastFpsUpdate;
            this.currentFPS = (int)((long)this.frameCount * 1000000000L / timeElapsed);
            this.frameCount = 0;
            this.lastFpsUpdate = currentTime;
        }
    }

    private void updateTPS(class_310 client) {
        long currentTime = System.nanoTime();
        if (currentTime - this.lastTpsUpdate >= 1000000000L) {
            this.currentTPS = client.method_1496() && client.method_1576() != null ? 20.0f : 20.0f;
            this.lastTpsUpdate = currentTime;
        }
    }
}

