/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi;

import io.github.zhengzhengyiyi.config.JsonManager;
import io.github.zhengzhengyiyi.config.ModConfig;
import io.github.zhengzhengyiyi.hub.HubRenderer;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.option.GameOptions;
import net.minecraft.client.option.Option;
import org.lwjgl.glfw.GLFW;
import org.quiltmc.loader.api.ModContainer;
import org.quiltmc.qsl.base.api.entrypoint.client.ClientModInitializer;
import org.quiltmc.qsl.lifecycle.api.client.event.ClientTickEvents;

public class LazyboostClient
implements ClientModInitializer {
    private long windowHandle = -1L;
    private boolean isFpsReduced = false;
    private int originalFpsLimit = 120;
    public static JsonManager<ModConfig> jsonManager = new JsonManager<ModConfig>("lazyboost", "lazyboost_config.json", ModConfig.class);

    public void onInitializeClient(ModContainer container) {
        HubRenderer.init();
        ClientTickEvents.START.register(mc -> {
            if (this.windowHandle == -1L && mc.getWindow() != null) {
                this.windowHandle = mc.getWindow().getHandle();
            }
            GameOptions options = MinecraftClient.getInstance().options;
            options.getGamma().set((Object)LazyboostClient.jsonManager.getConfig().gamma);
        });
        ClientTickEvents.END.register(this::onClientTick);
    }

    private void onClientTick(MinecraftClient client) {
        if (!LazyboostClient.jsonManager.getConfig().enableAutoFpsReduction) {
            return;
        }
        if (client.player == null || client.world == null || this.windowHandle == -1L) {
            return;
        }
        boolean isFocused = GLFW.glfwGetWindowAttrib((long)this.windowHandle, (int)131073) == 1;
        boolean isIconified = GLFW.glfwGetWindowAttrib((long)this.windowHandle, (int)131074) == 1;
        Option fpsOption = client.options.getMaxFps();
        if (isFocused && !isIconified) {
            if (this.isFpsReduced) {
                fpsOption.set((Object)this.originalFpsLimit);
                this.isFpsReduced = false;
            }
        } else {
            if (!this.isFpsReduced) {
                this.originalFpsLimit = (Integer)fpsOption.get();
            }
            if ((Integer)fpsOption.get() != 12) {
                fpsOption.set((Object)12);
            }
            this.isFpsReduced = true;
        }
    }
}

