/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.quiltmc.loader.api.QuiltLoader;

public class JsonManager<T> {
    private final Path configFile;
    private final Gson gson;
    private final Class<T> configClass;
    private final AtomicReference<T> currentConfig;
    private final ExecutorService watcherThread = Executors.newSingleThreadExecutor();

    public JsonManager(String modId, String fileName, Class<T> configClass) {
        this.configClass = configClass;
        this.currentConfig = new AtomicReference();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.configFile = Path.of(QuiltLoader.getConfigDir().toString(), fileName);
        this.loadConfig();
        this.startWatcher();
    }

    public T getConfig() {
        return this.currentConfig.get();
    }

    public synchronized void setConfig(T newConfig) {
        this.currentConfig.set(newConfig);
        this.saveConfig();
    }

    private void loadConfig() {
        if (Files.exists(this.configFile, new LinkOption[0])) {
            try (FileReader reader = new FileReader(this.configFile.toFile());){
                Object config = this.gson.fromJson((Reader)reader, this.configClass);
                this.currentConfig.set(config);
                System.out.println("Successfully loaded config from file: " + String.valueOf(this.configFile));
            }
            catch (IOException e) {
                System.err.println("Failed to load config file: " + e.getMessage());
                this.createDefaultConfig();
            }
        } else {
            this.createDefaultConfig();
        }
    }

    private void createDefaultConfig() {
        try {
            T defaultConfig = this.configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.currentConfig.set(defaultConfig);
            System.out.println("Config file not found, creating default: " + String.valueOf(this.configFile));
            this.saveConfig();
        }
        catch (Exception e) {
            System.err.println("Failed to create default config: " + e.getMessage());
        }
    }

    private synchronized void saveConfig() {
        try {
            Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(this.configFile.toFile());){
                this.gson.toJson(this.currentConfig.get(), (Appendable)writer);
                System.out.println("Successfully saved config to file: " + String.valueOf(this.configFile));
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config file: " + e.getMessage());
        }
    }

    private void startWatcher() {
        this.watcherThread.submit(() -> {
            try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                WatchKey key;
                Path dir = this.configFile.getParent();
                dir.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                System.out.println("Watching config file for changes: " + String.valueOf(dir));
                while ((key = watchService.take()) != null) {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        Path eventPath = (Path)event.context();
                        if (kind != StandardWatchEventKinds.ENTRY_MODIFY || !eventPath.equals(this.configFile.getFileName())) continue;
                        System.out.println("Config file modified, reloading...");
                        this.loadConfig();
                    }
                    boolean valid = key.reset();
                    if (valid) continue;
                    System.err.println("Watch key is no longer valid, stopping watcher.");
                    break;
                }
            }
            catch (IOException | InterruptedException e) {
                System.err.println("File watcher encountered an error: " + e.getMessage());
            }
        });
    }

    public void shutdown() {
        this.watcherThread.shutdownNow();
        try {
            if (!this.watcherThread.awaitTermination(5L, TimeUnit.SECONDS)) {
                System.err.println("File watcher thread did not terminate gracefully.");
            }
        }
        catch (InterruptedException e) {
            System.err.println("Shutdown interrupted while waiting for watcher to terminate: " + e.getMessage());
        }
    }
}

