/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.hub;

import io.github.zhengzhengyiyi.LazyboostClient;
import io.github.zhengzhengyiyi.config.ModConfig;
import java.text.DecimalFormat;
import net.minecraft.client.MinecraftClient;

public class HubRenderer {
    private static HubRenderer INSTANCE;
    private final DecimalFormat df = new DecimalFormat("#.##");
    private int currentFPS = 0;
    private float currentTPS = 20.0f;
    private int frameCount = 0;
    private long lastFpsUpdate = 0L;
    private long lastTpsUpdate = 0L;
    private static final long FPS_UPDATE_INTERVAL = 500000000L;
    private static final long TPS_UPDATE_INTERVAL = 1000000000L;

    private HubRenderer() {
    }

    @Deprecated
    public static void init() {
        if (INSTANCE == null) {
            INSTANCE = new HubRenderer();
        }
    }

    private void onHudRender() {
        this.renderCustomHud();
    }

    private void renderCustomHud() {
        MinecraftClient client = MinecraftClient.getInstance();
        ModConfig config = LazyboostClient.jsonManager.getConfig();
        if (!config.smallhub || client.player == null || client.world == null) {
            return;
        }
        this.updateFPS();
        this.updateTPS(client);
    }

    private void updateFPS() {
        long currentTime = System.nanoTime();
        ++this.frameCount;
        if (currentTime - this.lastFpsUpdate >= 500000000L) {
            long timeElapsed = currentTime - this.lastFpsUpdate;
            this.currentFPS = (int)((long)this.frameCount * 1000000000L / timeElapsed);
            this.frameCount = 0;
            this.lastFpsUpdate = currentTime;
        }
    }

    private void updateTPS(MinecraftClient client) {
        long currentTime = System.nanoTime();
        if (currentTime - this.lastTpsUpdate >= 1000000000L) {
            this.currentTPS = client.isIntegratedServerRunning() && client.getServer() != null ? 20.0f : 20.0f;
            this.lastTpsUpdate = currentTime;
        }
    }
}

