/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.mixin.client;

import com.google.gson.Gson;
import com.mojang.blaze3d.glfw.VideoMode;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import net.minecraft.SharedConstants;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.option.GameOptions;
import net.minecraft.client.option.Option;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameOptions.class})
public class GameOptionsMixin {
    @Shadow
    static Logger LOGGER;
    @Shadow
    static Gson GSON;
    @Shadow
    public MinecraftClient client;
    @Shadow
    public String optionsFile;

    @Shadow
    private void accept(Visitor visitor) {
    }

    @Shadow
    public void sendClientSettings() {
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"write"})
    private void write(CallbackInfo ci) {
        ci.cancel();
        try (final PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.optionsFile), StandardCharsets.UTF_8));){
            printWriter.println("version:" + SharedConstants.getGameVersion().getId());
            this.accept(new Visitor(){

                public void print(String key) {
                    printWriter.print(key);
                    printWriter.print(':');
                }

                @Override
                public <T> void accept(String key, Option<T> option) {
                    DataResult dataResult = option.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, option.get());
                    dataResult.result().ifPresent(json -> {
                        this.print(key);
                        printWriter.println(GSON.toJson(json));
                    });
                }

                @Override
                public int visitInt(String key, int current) {
                    this.print(key);
                    printWriter.println(current);
                    return current;
                }

                @Override
                public boolean visitBoolean(String key, boolean current) {
                    this.print(key);
                    printWriter.println(current);
                    return current;
                }

                @Override
                public String visitString(String key, String current) {
                    this.print(key);
                    printWriter.println(current);
                    return current;
                }

                @Override
                public float visitFloat(String key, float current) {
                    this.print(key);
                    printWriter.println(current);
                    return current;
                }

                @Override
                public <T> T visitObject(String key, T current, Function<String, T> decoder, Function<T, String> encoder) {
                    this.print(key);
                    printWriter.println(encoder.apply(current));
                    return current;
                }
            });
            if (this.client.getWindow().getVideoMode().isPresent()) {
                printWriter.println("fullscreenResolution:" + ((VideoMode)this.client.getWindow().getVideoMode().get()).asString());
            }
        }
        catch (Exception var6) {
            LOGGER.error("Failed to save options", (Throwable)var6);
        }
        this.sendClientSettings();
    }

    private static interface Visitor {
        public <T> void accept(String var1, Option<T> var2);

        public int visitInt(String var1, int var2);

        public boolean visitBoolean(String var1, boolean var2);

        public String visitString(String var1, String var2);

        public float visitFloat(String var1, float var2);

        public <T> T visitObject(String var1, T var2, Function<String, T> var3, Function<T, String> var4);
    }
}

