/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tessellator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormats;
import io.github.zhengzhengyiyi.LazyboostClient;
import io.github.zhengzhengyiyi.config.ModConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.render.Camera;
import net.minecraft.client.render.GameRenderer;
import net.minecraft.client.render.LightmapTextureManager;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.WorldRenderer;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Box;
import net.minecraft.util.math.Vec3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public class WorldRendererMixin {
    private static final List<Box> BOXES_TO_RENDER = new ArrayList<Box>();

    @Inject(method={"renderWeather"}, at={@At(value="HEAD")}, cancellable=true)
    private void disablerenderWeather(LightmapTextureManager frameGraphBuilder, float delta, double x, double y, double z, CallbackInfo ci) {
        if (LazyboostClient.jsonManager.getConfig().disableWeather) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRenderStart(CallbackInfo ci) {
        BOXES_TO_RENDER.clear();
    }

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderEntity(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, MatrixStack matrices, VertexConsumerProvider vertexConsumers, CallbackInfo ci) {
        MinecraftClient client = MinecraftClient.getInstance();
        ModConfig config = LazyboostClient.jsonManager.getConfig();
        double distance = entity.getPos().distanceTo(client.player.getPos());
        if (distance >= (double)config.entity_render_distance) {
            ci.cancel();
            if (client.player == null || client.world == null) {
                return;
            }
            Camera camera = client.gameRenderer.getCamera();
            Vec3d camPos = camera.getPos();
            Box box = entity.getBoundingBox();
            double minX = box.minX - camPos.x;
            double minY = box.minY - camPos.y;
            double minZ = box.minZ - camPos.z;
            double maxX = box.maxX - camPos.x;
            double maxY = box.maxY - camPos.y;
            double maxZ = box.maxZ - camPos.z;
            Tessellator tessellator = Tessellator.getInstance();
            BufferBuilder buffer = tessellator.getBufferBuilder();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::getPositionShader);
            buffer.begin(VertexFormat.DrawMode.DEBUG_LINES, VertexFormats.POSITION_COLOR);
            this.drawAABB(buffer, new Box(minX, minY, minZ, maxX, maxY, maxZ), 1.0f, 0.0f, 0.0f, 0.3f);
            tessellator.draw();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
    }

    private void drawAABB(BufferBuilder buffer, Box box, float r, float g, float b, float a) {
        buffer.vertex((double)((float)box.minX), (double)((float)box.minY), (double)((float)box.minZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.maxX), (double)((float)box.minY), (double)((float)box.minZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.maxX), (double)((float)box.minY), (double)((float)box.minZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.maxX), (double)((float)box.minY), (double)((float)box.maxZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.maxX), (double)((float)box.minY), (double)((float)box.maxZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.minX), (double)((float)box.minY), (double)((float)box.maxZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.minX), (double)((float)box.minY), (double)((float)box.maxZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.minX), (double)((float)box.minY), (double)((float)box.minZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.minX), (double)((float)box.maxY), (double)((float)box.minZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.maxX), (double)((float)box.maxY), (double)((float)box.minZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.maxX), (double)((float)box.maxY), (double)((float)box.minZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.maxX), (double)((float)box.maxY), (double)((float)box.maxZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.maxX), (double)((float)box.maxY), (double)((float)box.maxZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.minX), (double)((float)box.maxY), (double)((float)box.maxZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.minX), (double)((float)box.maxY), (double)((float)box.maxZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.minX), (double)((float)box.maxY), (double)((float)box.minZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.minX), (double)((float)box.minY), (double)((float)box.minZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.minX), (double)((float)box.maxY), (double)((float)box.minZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.maxX), (double)((float)box.minY), (double)((float)box.minZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.maxX), (double)((float)box.maxY), (double)((float)box.minZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.maxX), (double)((float)box.minY), (double)((float)box.maxZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.maxX), (double)((float)box.maxY), (double)((float)box.maxZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.minX), (double)((float)box.minY), (double)((float)box.maxZ)).color(r, g, b, a).next();
        buffer.vertex((double)((float)box.minX), (double)((float)box.maxY), (double)((float)box.maxZ)).color(r, g, b, a).next();
    }
}

