package com.zhengzhengyiyimc.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.zhengzhengyiyimc.config.ModConfig;

import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_2394;
import net.minecraft.class_638;

@Mixin(class_638.class)
public class WeatherParticlesMixin {
    @Inject(
        method = "addParticle(Lnet/minecraft/particle/ParticleEffect;DDDDDD)V",
        at = @At("HEAD"),
        cancellable = true
    )
    private void cancelParticles1(class_2394 parameters, 
                            double x, double y, double z,
                            double vx, double vy, double vz,
                            CallbackInfo ci) {
        if (AutoConfig.getConfigHolder(ModConfig.class).getConfig().disablePartical) ci.cancel();
    }

    @Inject(
        method = "addParticle(Lnet/minecraft/particle/ParticleEffect;ZDDDDDD)V",
        at = @At("HEAD"),
        cancellable = true
    )
    private void cancelParticles2(class_2394 parameters, boolean alwaysSpawn,
                            double x, double y, double z,
                            double vx, double vy, double vz,
                            CallbackInfo ci) {
        if (AutoConfig.getConfigHolder(ModConfig.class).getConfig().disablePartical) ci.cancel();
    }
}
