package com.zhengzhengyiyimc.mixin.client;

import java.util.ArrayList;
import java.util.List;

import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.zhengzhengyiyimc.config.ModConfig;

import me.shedaniel.autoconfig.AutoConfig;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.client.render.*;

@Mixin(class_761.class)
public class WorldRendererMixin {
    private static final List<class_238> BOXES_TO_RENDER = new ArrayList<>();

    @Inject(method = "renderWeather", at = @At("HEAD"), cancellable = true)
    private void disablerenderWeather(class_765 manager, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        if (AutoConfig.getConfigHolder(ModConfig.class).getConfig().disableWeather) ci.cancel();
    }

    @Inject(method = "render", at = @At("HEAD"))
    private void onRenderStart(CallbackInfo ci) {
        BOXES_TO_RENDER.clear();
    }

    @Inject(method = "renderEntity", at = @At("HEAD"), cancellable = true)
    private void renderEntity(class_1297 entity, double cameraX, double cameraY, double cameraZ, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        double distance = entity.method_19538().method_1022(client.field_1724.method_19538());
        if (distance >= config.entity_render_distance) {
            ci.cancel();

//            if (client.player == null || client.world == null) return;
//
//            Camera camera = client.gameRenderer.getCamera();
//            Vec3d camPos = camera.getPos();
//
//            Box box = entity.getBoundingBox();
//            double minX = box.minX - camPos.x;
//            double minY = box.minY - camPos.y;
//            double minZ = box.minZ - camPos.z;
//            double maxX = box.maxX - camPos.x;
//            double maxY = box.maxY - camPos.y;
//            double maxZ = box.maxZ - camPos.z;
//
//            Tessellator tessellator = Tessellator.getInstance();
//            BufferBuilder buffer = tessellator.getBuffer();
//            RenderSystem.enableBlend();
//            RenderSystem.defaultBlendFunc();
//            RenderSystem.depthMask(false);
//            RenderSystem.setShader(GameRenderer::getPositionColorProgram);
//            buffer.begin(VertexFormat.DrawMode.DEBUG_LINES, VertexFormats.POSITION_COLOR);
//
//            drawAABB(buffer, new Box(minX, minY, minZ, maxX, maxY, maxZ), 1.0f, 0.0f, 0.0f, 0.3f);
//
//            tessellator.draw();
//            RenderSystem.depthMask(true);
//            RenderSystem.disableBlend();
        }
    }
    
    private void drawAABB(class_287 buffer, class_238 box, float r, float g, float b, float a) {
        buffer.method_22912(box.field_1323, box.field_1322, box.field_1321).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1320, box.field_1322, box.field_1321).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1320, box.field_1322, box.field_1321).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1320, box.field_1322, box.field_1324).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1320, box.field_1322, box.field_1324).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1323, box.field_1322, box.field_1324).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1323, box.field_1322, box.field_1324).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1323, box.field_1322, box.field_1321).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1323, box.field_1325, box.field_1321).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1320, box.field_1325, box.field_1321).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1320, box.field_1325, box.field_1321).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1320, box.field_1325, box.field_1324).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1320, box.field_1325, box.field_1324).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1323, box.field_1325, box.field_1324).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1323, box.field_1325, box.field_1324).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1323, box.field_1325, box.field_1321).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1323, box.field_1322, box.field_1321).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1323, box.field_1325, box.field_1321).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1320, box.field_1322, box.field_1321).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1320, box.field_1325, box.field_1321).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1320, box.field_1322, box.field_1324).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1320, box.field_1325, box.field_1324).method_22915(r, g, b, a).method_1344();

        buffer.method_22912(box.field_1323, box.field_1322, box.field_1324).method_22915(r, g, b, a).method_1344();
        buffer.method_22912(box.field_1323, box.field_1325, box.field_1324).method_22915(r, g, b, a).method_1344();
    }

    @Inject(method = "renderLayer", at = @At("HEAD"), cancellable = true)
//    private void renderLayer(RenderLayer renderLayer, double cameraX, double cameraY, double cameraZ, Matrix4f positionMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
    private void onRenderLayer(class_1921 layer, class_4587 matrixStack, double x, double y, double z, Matrix4f projMatrix, CallbackInfo ci) {
        if (layer == class_1921.method_23583() && AutoConfig.getConfigHolder(ModConfig.class).getConfig().disablewater) {
            ci.cancel();
            
//            TODO - make sure water renders.
        }
    }
}
