/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.tpsdetective;

import com.mojang.logging.LogUtils;
import io.github.catomon.tpsdetective.Config;
import io.github.catomon.tpsdetective.DetectiveScreen;
import io.github.catomon.tpsdetective.ServerEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.slf4j.Logger;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static boolean froze = false;
    private static Long warningTime = 0L;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        LocalPlayer player;
        if (!((Boolean)Config.isOn.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            if (!mc.hasSingleplayerServer()) {
                return;
            }
            if (mc.isPaused()) {
                ServerEvents.lastServerTick = System.currentTimeMillis();
                return;
            }
            long now = System.currentTimeMillis();
            long delta = now - ServerEvents.lastServerTick;
            if (delta > 10000L) {
                if (!froze) {
                    froze = true;
                    mc.setScreen((Screen)new DetectiveScreen());
                }
            } else if (froze) {
                froze = false;
            }
        }
        if (((Boolean)Config.warnIfOn.get()).booleanValue() && (player = mc.player) != null && (warningTime = Long.valueOf(warningTime + 1L)) > 12000L) {
            warningTime = 0L;
            MutableComponent message = Component.literal((String)"[TPS Detective] Client warning: Detective was working for some time now. If it's not needed anymore, turn it off by going to Mods -> TPS Detective -> Config.");
            player.sendSystemMessage((Component)message);
        }
    }
}

