/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.tpsdetective;

import io.github.catomon.tpsdetective.TickProfiler;
import io.github.catomon.tpsdetective.util.LimitedLifoStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.Entity;

public class Detective {
    public static final Map<Entity, TickProfiler> entityProfilers = new ConcurrentHashMap<Entity, TickProfiler>();
    public static final ConcurrentHashMap<Entity, Long> lastTickDurations = new ConcurrentHashMap();
    public static LimitedLifoStack<Entity> entityJoinStack = new LimitedLifoStack(128);
    public static Entity lastTickedEntity = null;
    public static boolean entityTicking = false;
    public static final ConcurrentHashMap<Entity, Long> lastTickStartTimes = new ConcurrentHashMap();
    public static final Map<String, TickProfiler> structureProfilers = new ConcurrentHashMap<String, TickProfiler>();
    public static final ConcurrentHashMap<String, Long> lastStructureDurations = new ConcurrentHashMap();
    public static LimitedLifoStack<String> structureStartStack = new LimitedLifoStack(3);
    public static boolean structureInProcess = false;
    public static String lastStructStartId = "none";

    public static void recordEntityTickStart(Entity entity) {
        long startTime = System.nanoTime();
        TickProfiler profiler = entityProfilers.computeIfAbsent(entity, e -> new TickProfiler(10000, 20));
        profiler.recordTick(startTime);
        long currentTime = System.nanoTime();
        lastTickStartTimes.put(entity, currentTime);
        lastTickedEntity = entity;
        entityTicking = true;
    }

    public static void recordEntityTickEnd(Entity entity) {
        Long startTime;
        lastTickedEntity = null;
        entityTicking = false;
        long endTime = System.nanoTime();
        TickProfiler profiler = entityProfilers.get(entity);
        if (profiler != null && (startTime = profiler.getLastTickTime()) != null) {
            long duration = endTime - startTime;
            lastTickDurations.put(entity, duration);
            profiler.recordDuration(duration);
        }
    }

    public static List<Entity> getEntitiesOrderedByLastTick() {
        return lastTickStartTimes.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).map(Map.Entry::getKey).limit(128L).toList();
    }

    public static List<Entity> combineEntitiesOrderedByJoinStackAndTick() {
        ArrayList<Entity> joinListSnapshot = new ArrayList<Entity>(entityJoinStack.toList());
        HashMap<Entity, Integer> joinIndexMap = new HashMap<Entity, Integer>();
        for (int i = 0; i < joinListSnapshot.size(); ++i) {
            joinIndexMap.put((Entity)joinListSnapshot.get(i), i);
        }
        HashSet tickStartKeysSnapshot = new HashSet(lastTickStartTimes.keySet());
        LinkedHashSet<Entity> combinedSet = new LinkedHashSet<Entity>(joinListSnapshot);
        combinedSet.addAll(tickStartKeysSnapshot);
        ArrayList<Entity> combinedList = new ArrayList<Entity>(combinedSet);
        combinedList.sort((e1, e2) -> {
            boolean e1Ticked = tickStartKeysSnapshot.contains(e1);
            boolean e2Ticked = tickStartKeysSnapshot.contains(e2);
            if (!e1Ticked && !e2Ticked) {
                int idx1 = joinIndexMap.getOrDefault(e1, Integer.MAX_VALUE);
                int idx2 = joinIndexMap.getOrDefault(e2, Integer.MAX_VALUE);
                return Integer.compare(idx1, idx2);
            }
            if (!e1Ticked && e2Ticked) {
                return -1;
            }
            if (e1Ticked && !e2Ticked) {
                return 1;
            }
            Long tick1 = lastTickStartTimes.get(e1);
            Long tick2 = lastTickStartTimes.get(e2);
            if (tick1 == null && tick2 == null) {
                return 0;
            }
            if (tick1 == null) {
                return 1;
            }
            if (tick2 == null) {
                return -1;
            }
            return Long.compare(tick2, tick1);
        });
        return combinedList;
    }

    public static void recordStructureStart(String id) {
        long startTime = System.nanoTime();
        TickProfiler profiler = structureProfilers.computeIfAbsent(id, s -> new TickProfiler(10000, 20));
        profiler.recordTick(startTime);
        structureStartStack.push(id);
        lastStructStartId = id;
        structureInProcess = true;
    }

    public static void recordStructureEnd(String id) {
        Long startTime;
        structureInProcess = false;
        long endTime = System.nanoTime();
        TickProfiler profiler = structureProfilers.get(id);
        if (profiler != null && (startTime = profiler.getLastTickTime()) != null) {
            long duration = endTime - startTime;
            lastStructureDurations.put(id, duration);
            profiler.recordDuration(duration);
        }
    }

    public static void cleanupOldProfilers() {
        long now = System.nanoTime();
        long cutoff = now - 60000000000L;
        entityProfilers.entrySet().removeIf(entry -> {
            TickProfiler profiler = (TickProfiler)entry.getValue();
            Long lastTick = profiler.getLastTickTime();
            return lastTick == null || lastTick < cutoff;
        });
        structureProfilers.entrySet().removeIf(entry -> {
            TickProfiler profiler = (TickProfiler)entry.getValue();
            Long lastTick = profiler.getLastTickTime();
            return lastTick == null || lastTick < cutoff;
        });
        lastTickDurations.entrySet().removeIf(entry -> {
            Entity e = (Entity)entry.getKey();
            return !entityProfilers.containsKey(e);
        });
        lastStructureDurations.entrySet().removeIf(entry -> {
            String id = (String)entry.getKey();
            return !structureProfilers.containsKey(id);
        });
    }

    public static void cleanupAll() {
        entityProfilers.clear();
        lastTickDurations.clear();
        entityJoinStack.clear();
        lastTickStartTimes.clear();
        lastTickedEntity = null;
        entityTicking = false;
        structureProfilers.clear();
        lastStructureDurations.clear();
        structureStartStack.clear();
        structureInProcess = false;
        lastStructStartId = "none";
    }
}

