/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.tpsdetective;

import io.github.catomon.tpsdetective.Config;
import io.github.catomon.tpsdetective.Detective;
import io.github.catomon.tpsdetective.LagGoal;
import io.github.catomon.tpsdetective.TickProfiler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class DetectiveScreen
extends Screen {
    private final List<Entity> infoList;
    private final List<Component> displayComponents = new ArrayList<Component>();
    private int currentPage = 0;
    private final int linesPerPage = 12;

    public DetectiveScreen() {
        super((Component)Component.translatable((String)"screen.tps_detective.detective_screen"));
        this.infoList = Detective.combineEntitiesOrderedByJoinStackAndTick();
    }

    protected void init() {
        super.init();
        this.displayComponents.clear();
        TextColor red = TextColor.fromRgb((int)0xFF5555);
        TextColor orange = TextColor.fromRgb((int)0xFFAA00);
        TextColor white = TextColor.fromRgb((int)0xFFFFFF);
        if (Detective.structureInProcess) {
            this.displayComponents.add((Component)Component.literal((String)(Detective.lastStructStartId + " <- Unfinished structure")).withStyle(style -> style.withColor(red)));
        }
        Entity entityStuckTicking = Detective.lastTickedEntity;
        if (Detective.entityTicking && entityStuckTicking != null) {
            String entityName = entityStuckTicking.getName().getString();
            ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityStuckTicking.getType());
            String modId = id.toString();
            String entityText = entityName + " / " + modId;
            this.displayComponents.add((Component)Component.literal((String)(entityText + " <- Unfinished ticking")).withStyle(style -> style.withColor(red)));
        } else {
            entityStuckTicking = null;
        }
        ArrayList<Entity> lastlyTickedEntities = new ArrayList<Entity>();
        ArrayList<Entity> otherEntities = new ArrayList<Entity>();
        Entity lastTickedEntity = null;
        Long lastTickedEntityTickTime = null;
        for (Entity entity : this.infoList) {
            if (Detective.lastTickStartTimes.get(entity) == null) continue;
            lastTickedEntity = entity;
            lastTickedEntityTickTime = Detective.lastTickStartTimes.get(lastTickedEntity);
            break;
        }
        if (lastTickedEntity == null) {
            otherEntities.addAll(this.infoList);
        } else {
            for (Entity entity : this.infoList) {
                Long tick = Detective.lastTickStartTimes.get(entity);
                if (entity.equals((Object)entityStuckTicking)) continue;
                if (tick != null && tick.equals(lastTickedEntityTickTime)) {
                    lastlyTickedEntities.add(entity);
                    continue;
                }
                otherEntities.add(entity);
            }
        }
        otherEntities.sort((e1, e2) -> {
            long sum1 = Detective.entityProfilers.getOrDefault(e1, new TickProfiler(0, 0)).getRecentTickDurations().stream().mapToLong(Long::longValue).sum();
            long sum2 = Detective.entityProfilers.getOrDefault(e2, new TickProfiler(0, 0)).getRecentTickDurations().stream().mapToLong(Long::longValue).sum();
            if (sum1 == 0L && sum2 == 0L) {
                return 0;
            }
            if (sum1 == 0L) {
                return -1;
            }
            if (sum2 == 0L) {
                return 1;
            }
            return Long.compare(sum2, sum1);
        });
        ArrayList<Entity> sortedEntities = new ArrayList<Entity>();
        sortedEntities.addAll(lastlyTickedEntities);
        sortedEntities.addAll(otherEntities);
        for (Entity entity : sortedEntities) {
            Object lineText = entity.getName().getString();
            ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            String modId = id.toString();
            lineText = (String)lineText + " / " + modId;
            if (lastlyTickedEntities.contains(entity)) {
                lineText = (String)lineText + " <- Last ticked";
            } else if (Detective.lastTickStartTimes.get(entity) == null) {
                lineText = (String)lineText + " <- Not ticked yet";
            }
            if (Config.IS_DEBUG && LagGoal.theCause != null && LagGoal.theCause.equals((Object)entity)) {
                lineText = (String)lineText + " <*";
            }
            long ticksNanoSum = Detective.entityProfilers.getOrDefault(entity, new TickProfiler(0, 0)).getRecentTickDurations().stream().mapToLong(Long::longValue).sum();
            lineText = (String)lineText + " " + ticksNanoSum / 1000000L + "ms/10s";
            TextColor color = lastlyTickedEntities.contains(entity) ? orange : (Detective.lastTickStartTimes.get(entity) == null ? orange : white);
            this.displayComponents.add((Component)Component.literal((String)lineText).withStyle(style -> style.withColor(color)));
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> this.onClose()).bounds(20, this.height - 40, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.tps_detective.turn_off"), button -> {
            Config.isOn.set((Object)false);
            Config.SPEC.save();
            this.onClose();
        }).bounds(this.width - 20 - 100, this.height - 40, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"< Prev"), button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        }).bounds(this.width / 2 - 100, this.height - 40, 80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Next >"), button -> {
            if ((this.currentPage + 1) * 12 < sortedEntities.size()) {
                ++this.currentPage;
            }
        }).bounds(this.width / 2 + 20, this.height - 40, 80, 20).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
        int startY = 50;
        int lineHeight = 12;
        int startIndex = this.currentPage * 12;
        int endIndex = Math.min(startIndex + 12, this.displayComponents.size());
        for (int i = startIndex; i < endIndex; ++i) {
            guiGraphics.drawCenteredString(this.font, this.displayComponents.get(i), this.width / 2, startY + (i - startIndex) * lineHeight, 0);
        }
    }

    public boolean isPauseScreen() {
        return true;
    }
}

