/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.tpsdetective;

import io.github.catomon.tpsdetective.Config;
import io.github.catomon.tpsdetective.Detective;
import io.github.catomon.tpsdetective.LagGoal;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class ServerEvents {
    public static volatile long lastServerTick = System.currentTimeMillis();
    private static Long cleanupTime = 0L;
    private static Long warningTime = 0L;

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!((Boolean)Config.isOn.get()).booleanValue()) {
            return;
        }
        MinecraftServer server = event.getLevel().getServer();
        if (server != null && server.isDedicatedServer()) {
            return;
        }
        if (!event.getEntity().level().isClientSide) {
            Detective.entityJoinStack.push(event.getEntity());
        }
        if (Config.IS_DEBUG && (entity = event.getEntity()) instanceof Villager) {
            Villager villager = (Villager)entity;
            villager.goalSelector.addGoal(0, (Goal)new LagGoal((Entity)villager));
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        if (!((Boolean)Config.isOn.get()).booleanValue()) {
            return;
        }
        MinecraftServer server = event.getServer();
        if (server.isDedicatedServer()) {
            return;
        }
        lastServerTick = System.currentTimeMillis();
        Long l = cleanupTime;
        cleanupTime = cleanupTime + 1L;
        if (cleanupTime > 1200L) {
            cleanupTime = 0L;
            Detective.cleanupOldProfilers();
        }
        if (((Boolean)Config.warnIfOn.get()).booleanValue() && (warningTime = Long.valueOf(warningTime + 1L)) > 12000L) {
            warningTime = 0L;
            MutableComponent message = Component.literal((String)"[TPS Detective] Server warning: Detective was working for some time now. If it's not needed anymore, turn it off by going to Mods -> TPS Detective -> Config.");
            server.getPlayerList().getPlayers().forEach(arg_0 -> ServerEvents.lambda$onServerTick$0((Component)message, arg_0));
        }
    }

    private static /* synthetic */ void lambda$onServerTick$0(Component message, ServerPlayer player) {
        player.sendSystemMessage(message);
    }
}

