/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.tpsdetective;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TickProfiler {
    private final long[] tickTimes;
    private final long[] durations;
    private int index = 0;
    private final int maxSamples;

    public TickProfiler(int profileDurationMs, int ticksPerSecond) {
        this.maxSamples = ticksPerSecond * profileDurationMs / 1000;
        this.tickTimes = new long[this.maxSamples];
        this.durations = new long[this.maxSamples];
    }

    public synchronized void recordTick(long nanoTime) {
        this.tickTimes[this.index] = nanoTime;
        this.durations[this.index] = 0L;
        this.index = (this.index + 1) % this.maxSamples;
    }

    public synchronized void recordDuration(long durationNano) {
        int durationIndex = (this.index - 1 + this.maxSamples) % this.maxSamples;
        this.durations[durationIndex] = durationNano;
    }

    public synchronized Long getLastTickTime() {
        int lastIndex = (this.index - 1 + this.maxSamples) % this.maxSamples;
        long lastTick = this.tickTimes[lastIndex];
        return lastTick == 0L ? null : Long.valueOf(lastTick);
    }

    public synchronized List<Long> getRecentTickDurations() {
        ArrayList<Long> recentDurations = new ArrayList<Long>();
        long now = System.nanoTime();
        long cutoff = now - (long)this.maxSamples * 50000000L;
        for (int i = 0; i < this.maxSamples; ++i) {
            int idx = (this.index - 1 - i + this.maxSamples) % this.maxSamples;
            long tickTime = this.tickTimes[idx];
            long duration = this.durations[idx];
            if (tickTime == 0L || tickTime < cutoff) break;
            if (duration <= 0L) continue;
            recentDurations.add(duration);
        }
        Collections.reverse(recentDurations);
        return recentDurations;
    }
}

