/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.tpsdetective.mixin;

import io.github.catomon.tpsdetective.Config;
import io.github.catomon.tpsdetective.Detective;
import io.github.catomon.tpsdetective.util.StructureUtils;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkGenerator.class})
public abstract class ChunkGeneratorMixin {
    @Inject(method={"tryGenerateStructure"}, at={@At(value="HEAD")})
    private void tickdetective$onTryGenerateStructure(StructureSet.StructureSelectionEntry entry, StructureManager manager, RegistryAccess registryAccess, RandomState randomState, StructureTemplateManager templateManager, long seed, ChunkAccess chunk, ChunkPos chunkPos, SectionPos sectionPos, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)Config.isOn.get()).booleanValue()) {
            Structure structure = (Structure)entry.structure().value();
            ResourceLocation id = StructureUtils.getStructureResLoc(registryAccess, structure);
            Detective.recordStructureStart(id != null ? id.toString() : "unknown");
        }
    }

    @Inject(method={"tryGenerateStructure"}, at={@At(value="RETURN")})
    private void tickdetective$onStructureComplete(StructureSet.StructureSelectionEntry entry, StructureManager manager, RegistryAccess registryAccess, RandomState randomState, StructureTemplateManager templateManager, long seed, ChunkAccess chunk, ChunkPos chunkPos, SectionPos sectionPos, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)Config.isOn.get()).booleanValue()) {
            Structure structure = (Structure)entry.structure().value();
            ResourceLocation id = StructureUtils.getStructureResLoc(registryAccess, structure);
            Detective.recordStructureEnd(id != null ? id.toString() : "unknown");
        }
    }
}

