/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.tpsdetective.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class LimitedLifoStack<E> {
    private final Deque<E> deque = new ArrayDeque();
    private final int capacity;

    public LimitedLifoStack(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be positive");
        }
        this.capacity = capacity;
    }

    public void push(E item) {
        if (this.deque.size() >= this.capacity) {
            this.deque.pollLast();
        }
        this.deque.addFirst(item);
    }

    public E pop() {
        return this.deque.pollFirst();
    }

    public E peek() {
        return this.deque.peekFirst();
    }

    public List<E> toList() {
        return new ArrayList<E>(this.deque);
    }

    public int size() {
        return this.deque.size();
    }

    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public void clear() {
        this.deque.clear();
    }
}

